/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util.formallang;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.internal.Join;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.util.formallang.Nfa;
import org.eclipse.xtext.util.formallang.NfaUtil;
import org.eclipse.xtext.util.formallang.Pda;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdaUtil {
    @Inject
    protected NfaUtil nfaUtil = new NfaUtil();
    public final long UNREACHABLE = Long.MAX_VALUE;

    public <S, P> boolean canReach(Pda<S, P> pda, S state, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.distanceTo(pda, Collections.singleton(state), stack, matches, canPass) != Long.MAX_VALUE;
    }

    protected <T> StackItem<T> createStack(Iterator<T> stack) {
        if (stack.hasNext()) {
            return new StackItem<T>(stack, stack.next());
        }
        return new StackItem<Object>(null, null);
    }

    public <S, P> long distanceTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.size();
        }
        return Long.MAX_VALUE;
    }

    public <S, P> Nfa<S> filterUnambiguousPaths(Pda<S, P> pda) {
        HashMap followers = Maps.newHashMap();
        Map distanceMap = this.nfaUtil.distanceToFinalStateMap(pda);
        this.filterUnambiguousPaths(pda, pda.getStart(), distanceMap, followers);
        return new NfaUtil.NFAImpl(pda.getStart(), pda.getStop(), followers);
    }

    protected <S, P> void filterUnambiguousPaths(Pda<S, P> pda, S state, Map<S, Integer> dist, Map<S, List<S>> followers) {
        if (followers.containsKey(state)) {
            return;
        }
        ArrayList f = Lists.newArrayList(pda.getFollowers(state));
        if (f.size() <= 1) {
            followers.put(state, f);
            if (f.size() == 1) {
                this.filterUnambiguousPaths(pda, f.get(0), dist, followers);
            }
            return;
        }
        int closestDist = dist.get(f.get(0));
        Object closest = f.get(0);
        int i = 1;
        while (i < f.size()) {
            int d = dist.get(f.get(i));
            if (d < closestDist) {
                closestDist = d;
                closest = f.get(i);
            }
            ++i;
        }
        IsPop isPop = new IsPop(pda);
        Set closestPops = this.nfaUtil.findFirst(pda, Collections.singleton(closest), isPop);
        Iterator it = f.iterator();
        while (it.hasNext()) {
            Set nextPops;
            Object next = it.next();
            if (next == closest || closestPops.equals(nextPops = this.nfaUtil.findFirst(pda, Collections.singleton(next), isPop))) continue;
            it.remove();
        }
        followers.put(state, f);
        for (Object follower : f) {
            this.filterUnambiguousPaths(pda, follower, dist, followers);
        }
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        return this.shortestPathTo(pda, pda.getStart(), stack, matches, canPass);
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, Iterator<P> stack, S match) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(match), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.trace(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestPathToFinalState(Pda<S, P> pda, Iterator<P> stack) {
        return this.shortestPathTo(pda, pda.getStart(), stack, Predicates.equalTo(pda.getStop()), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, starts, stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, Predicate<S> matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, matches, Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, Iterator<P> stack, S matches) {
        return this.shortestStackpruningPathTo(pda, pda.getStart(), stack, Predicates.equalTo(matches), Predicates.alwaysTrue());
    }

    public <S, P> List<S> shortestStackpruningPathTo(Pda<S, P> pda, S start, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        TraceItem<S, P> trace = this.traceToWithPruningStack(pda, Collections.singleton(start), stack, matches, canPass);
        if (trace != null) {
            return trace.asList();
        }
        return null;
    }

    protected <S, P> TraceItem<S, P> trace(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        for (S start : starts) {
            current.add(new TraceItem<S, P>(null, start, stackItem));
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        return new TraceItem(trace, follower, trace.stackitem);
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return null;
    }

    protected <S, P> TraceItem<S, P> traceToWithPruningStack(Pda<S, P> pda, Iterable<S> starts, Iterator<P> stack, Predicate<S> matches, Predicate<S> canPass) {
        StackItem<P> stackItem = this.createStack(stack);
        ArrayList current = Lists.newArrayList();
        HashSet visited = Sets.newHashSet(starts);
        TraceItem result = null;
        for (S start : starts) {
            TraceItem<S, P> item = new TraceItem<S, P>(null, start, stackItem);
            current.add(item);
        }
        int counter = stackItem.size() * -1;
        while (current.size() > 0 && counter < visited.size()) {
            ArrayList newCurrent = Lists.newArrayList();
            for (TraceItem trace : current) {
                for (Object follower : pda.getFollowers(trace.state)) {
                    if (matches.apply(follower)) {
                        TraceItem found = new TraceItem(trace, follower, trace.stackitem);
                        if (found.stackitem == null) {
                            return found;
                        }
                        if (result == null || result.stackitem.size() > found.stackitem.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        } else if (result.stackitem.size() == found.stackitem.size() && result.size() > found.size()) {
                            result = found;
                            counter = result.stackitem.size() * -1;
                        }
                    }
                    if (!canPass.apply(follower)) continue;
                    P push = pda.getPush(follower);
                    visited.add(follower);
                    if (push != null) {
                        StackItem pushed = trace.stackitem.push(push);
                        newCurrent.add(new TraceItem(trace, follower, pushed));
                        continue;
                    }
                    P pop = pda.getPop(follower);
                    if (pop != null) {
                        if (trace.stackitem == null || pop != trace.stackitem.peek()) continue;
                        StackItem popped = trace.stackitem.pop();
                        newCurrent.add(new TraceItem(trace, follower, popped));
                        continue;
                    }
                    newCurrent.add(new TraceItem(trace, follower, trace.stackitem));
                }
            }
            current = newCurrent;
            ++counter;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IsPop<S, P>
    implements Predicate<S> {
        private final Pda<S, P> pda;

        private IsPop(Pda<S, P> pda) {
            this.pda = pda;
        }

        public boolean apply(S input) {
            return this.pda.getPop(input) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StackItem<T> {
        protected StackItem<T> parent;
        protected Iterator<T> parentIt;
        protected T value;

        public StackItem(Iterator<T> parentIt, T value) {
            this.parentIt = parentIt;
            this.value = value;
        }

        public StackItem(StackItem<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }

        public T peek() {
            return this.value;
        }

        public StackItem<T> pop() {
            if (this.parent != null) {
                return this.parent;
            }
            if (this.parentIt != null && this.parentIt.hasNext()) {
                this.parent = new StackItem<T>(this.parentIt, this.parentIt.next());
                return this.parent;
            }
            return null;
        }

        public StackItem<T> push(T value) {
            return new StackItem<T>(this, value);
        }

        public int size() {
            int result = 0;
            StackItem<T> current = this;
            while (current != null) {
                ++result;
                current = current.pop();
            }
            return result;
        }

        public String toString() {
            ArrayList result = Lists.newArrayList();
            StackItem<T> current = this;
            while (current != null) {
                if (current.value != null) {
                    result.add(current.value.toString());
                }
                current = current.pop();
            }
            return Join.join((String)", ", (Iterable)result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TraceItem<S, P> {
        protected TraceItem<S, P> parent;
        protected StackItem<P> stackitem;
        protected S state;

        public TraceItem(TraceItem<S, P> parent, S state, StackItem<P> stackitem) {
            this.parent = parent;
            this.state = state;
            this.stackitem = stackitem;
        }

        public List<S> asList() {
            ArrayList result = Lists.newArrayList();
            TraceItem<S, P> current = this;
            while (current != null) {
                result.add(current.state);
                current = current.parent;
            }
            Collections.reverse(result);
            return result;
        }

        public int size() {
            int result = 0;
            TraceItem<S, P> current = this;
            while (current != null) {
                ++result;
                current = current.parent;
            }
            return result;
        }

        public String toString() {
            return "States: " + this.asList() + " Stack: " + this.stackitem;
        }
    }
}

