/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import org.eclipse.xtext.util.ITextRegion;

public class ReplaceRegion {
    private final int offset;
    private final int length;
    private final String text;

    public ReplaceRegion(ITextRegion region, String text) {
        this(region.getOffset(), region.getLength(), text);
    }

    public ReplaceRegion(int offset, int length, String text) {
        this.offset = offset;
        this.length = length;
        this.text = text;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public int getEndOffset() {
        return this.offset + this.length;
    }

    public String getText() {
        return this.text;
    }

    public ReplaceRegion shiftBy(int offset) {
        if (offset == 0) {
            return this;
        }
        return new ReplaceRegion(this.offset + offset, this.length, this.text);
    }

    public void applyTo(StringBuilder builder) {
        builder.replace(this.offset, this.getEndOffset(), this.text);
    }

    public String toString() {
        return "replace region [" + this.offset + " / length: " + this.length + "]";
    }
}

