/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.AbstractRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.EmfResourceChangeUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class EmfResourceRenameStrategy
extends AbstractRenameStrategy {
    private EmfResourceChangeUtil changeUtil;

    protected EmfResourceRenameStrategy(ENamedElement targetEObject, EmfResourceChangeUtil changeUtil) {
        super((EObject)targetEObject, EcorePackage.Literals.ENAMED_ELEMENT__NAME);
        this.changeUtil = changeUtil;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        Resource targetResource = resourceSet.getResource(this.getTargetElementOriginalURI().trimFragment(), false);
        EcoreUtil.resolveAll((Resource)targetResource);
        this.applyDeclarationChange(newName, resourceSet);
        try {
            this.changeUtil.addSaveAsUpdate(targetResource, updateAcceptor);
        }
        catch (IOException exc) {
            throw new RefactoringStatusException(exc, true);
        }
    }

    public static class Provider
    implements IRenameStrategy.Provider {
        @Inject
        private EmfResourceChangeUtil changeUtil;

        public IRenameStrategy get(EObject targetEObject, IRenameElementContext renameElementContext) {
            if (targetEObject instanceof ENamedElement) {
                return new EmfResourceRenameStrategy((ENamedElement)targetEObject, this.changeUtil);
            }
            return null;
        }
    }
}

