/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.partialEditing;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.ISyntheticResourceProvider;
import org.eclipse.xtext.ui.codetemplates.ui.partialEditing.SourceViewerHandle;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class SourceViewerHandleFactory {
    @Inject
    private XtextSourceViewer.Factory sourceViewerFactory;
    @Inject
    private Provider<XtextSourceViewerConfiguration> sourceViewerConfigurationProvider;
    @Inject
    private Provider<XtextDocument> documentProvider;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitionerProvider;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;

    public SourceViewerHandle create(Composite parent, ISyntheticResourceProvider resourceProvider) {
        final XtextSourceViewer viewer = this.sourceViewerFactory.createSourceViewer(parent, null, null, false, 2816);
        XtextSourceViewerConfiguration viewerConfiguration = (XtextSourceViewerConfiguration)this.sourceViewerConfigurationProvider.get();
        viewer.configure((SourceViewerConfiguration)viewerConfiguration);
        final SourceViewerDecorationSupport viewerDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)viewer, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedColors());
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        UnmodifiableIterator e = Iterators.filter(annotationPreferences.getAnnotationPreferences().iterator(), AnnotationPreference.class);
        while (e.hasNext()) {
            viewerDecorationSupport.setAnnotationPreference((AnnotationPreference)e.next());
        }
        viewerDecorationSupport.install(this.preferenceStoreAccess.getPreferenceStore());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                viewerDecorationSupport.dispose();
            }
        });
        final XtextDocument document = (XtextDocument)this.documentProvider.get();
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitionerProvider.get();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioner);
        final SourceViewerHandle result = new SourceViewerHandle(document, viewer, viewerConfiguration, resourceProvider);
        ValidationJob job = new ValidationJob(this.resourceValidator, (IReadAccess)document, new IValidationIssueProcessor(){
            private AnnotationIssueProcessor annotationIssueProcessor;

            public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                IValidationIssueProcessor issueProcessor = result.getIssueProcessor();
                if (issueProcessor != null) {
                    issueProcessor.processIssues(issues, monitor);
                }
                if (this.annotationIssueProcessor == null) {
                    this.annotationIssueProcessor = new AnnotationIssueProcessor((IXtextDocument)document, viewer.getAnnotationModel(), (IssueResolutionProvider)new IssueResolutionProvider.NullImpl());
                }
                if (this.annotationIssueProcessor != null) {
                    this.annotationIssueProcessor.processIssues(issues, monitor);
                }
            }
        }, CheckMode.FAST_ONLY);
        document.setValidationJob((Job)job);
        return result;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }
}

