/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AbstractCompoundSelectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDescriptionsData
extends AbstractCompoundSelectable {
    private final Map<URI, IResourceDescription> resourceDescriptionMap;
    private final Multimap<QualifiedName, IResourceDescription> lookupMap;

    public ResourceDescriptionsData(Iterable<IResourceDescription> descriptions) {
        this.resourceDescriptionMap = Maps.uniqueIndex(descriptions, (Function)new Function<IResourceDescription, URI>(){

            public URI apply(IResourceDescription from) {
                return from.getURI();
            }
        });
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (IResourceDescription description : descriptions) {
            for (IEObjectDescription object : description.getExportedObjects()) {
                QualifiedName lowerCase = object.getName().toLowerCase();
                builder.put((Object)lowerCase, (Object)description);
            }
        }
        this.lookupMap = builder.build();
    }

    protected ResourceDescriptionsData(Map<URI, IResourceDescription> resourceDescriptionMap, Multimap<QualifiedName, IResourceDescription> lookupMap) {
        this.resourceDescriptionMap = resourceDescriptionMap;
        this.lookupMap = lookupMap;
    }

    public ResourceDescriptionsData copy() {
        return new ResourceDescriptionsData(Maps.newHashMap(this.resourceDescriptionMap), (Multimap<QualifiedName, IResourceDescription>)HashMultimap.create(this.lookupMap));
    }

    public Iterable<IResourceDescription> getAllResourceDescriptions() {
        return this.resourceDescriptionMap.values();
    }

    public IResourceDescription getResourceDescription(URI uri) {
        return this.resourceDescriptionMap.get(uri);
    }

    public void removeDescription(URI uri) {
        IResourceDescription oldDescription = this.resourceDescriptionMap.remove(uri);
        if (oldDescription != null) {
            for (IEObjectDescription object : oldDescription.getExportedObjects()) {
                this.lookupMap.remove((Object)object.getName().toLowerCase(), (Object)oldDescription);
            }
        }
    }

    public Iterable<IEObjectDescription> getExportedObjects(final EClass type, final QualifiedName qualifiedName, final boolean ignoreCase) {
        if (this.lookupMap.containsKey((Object)qualifiedName.toLowerCase())) {
            Collection candidates = this.lookupMap.get((Object)qualifiedName.toLowerCase());
            return Iterables.concat((Iterable)Iterables.transform((Iterable)candidates, (Function)new Function<ISelectable, Iterable<IEObjectDescription>>(){

                public Iterable<IEObjectDescription> apply(ISelectable from) {
                    if (from != null) {
                        return from.getExportedObjects(type, qualifiedName, ignoreCase);
                    }
                    return Collections.emptyList();
                }
            }));
        }
        return Collections.emptyList();
    }

    public Iterable<IEObjectDescription> getExportedObjectsByObject(EObject object) {
        URI resourceURI = EcoreUtil2.getNormalizedResourceURI((EObject)object);
        IResourceDescription description = this.getResourceDescription(resourceURI);
        if (description == null) {
            return Collections.emptyList();
        }
        return description.getExportedObjectsByObject(object);
    }

    protected Iterable<IResourceDescription> getSelectables() {
        return this.resourceDescriptionMap.values();
    }

    public Set<URI> getAllURIs() {
        return this.resourceDescriptionMap.keySet();
    }

    public void addDescription(URI uri, IResourceDescription newDescription) {
        this.removeDescription(uri);
        if (newDescription != null) {
            this.resourceDescriptionMap.put(uri, newDescription);
            for (IEObjectDescription object : newDescription.getExportedObjects()) {
                this.lookupMap.put((Object)object.getName().toLowerCase(), (Object)newDescription);
            }
        }
    }
}

