/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model.project;

import com.google.common.base.CharMatcher;
import com.google.inject.Injector;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.BundleProjectConfig;
import org.eclipse.xtext.xtext.generator.model.project.IRuntimeProjectConfig;

public class RuntimeProjectConfig
extends BundleProjectConfig
implements IRuntimeProjectConfig {
    private String ecoreModelPath;
    private IXtextGeneratorFileSystemAccess ecoreModel;

    public void setEcoreModel(String path) {
        this.ecoreModelPath = path;
    }

    @Override
    public String getEcoreModelFolder() {
        String rootPath = this.getRoot().getPath();
        String ecoreModelPath = this.ecoreModel.getPath();
        if (ecoreModelPath.startsWith(rootPath)) {
            String relativePath = ecoreModelPath.substring(rootPath.length()).replace("\\", "/");
            return CharMatcher.is((char)'/').trimFrom((CharSequence)relativePath);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Could not derive the Ecore model folder from the project configuration.\n");
        builder.append("Please make sure that 'root' is a prefix of 'ecoreModel'.\n");
        builder.append("was (root='").append(rootPath).append("', ecoreModel='").append(ecoreModelPath).append("')");
        throw new RuntimeException(builder.toString());
    }

    @Override
    public void initialize(Injector injector) {
        super.initialize(injector);
        if (this.ecoreModelPath != null) {
            this.ecoreModel = this.getOwner().newFileSystemAccess(this.ecoreModelPath, true);
            this.ecoreModel.initialize(injector);
        }
    }

    @Override
    public String getXbaseLibVersionLowerBound() {
        return "2.38.0";
    }

    @Override
    public String getXtendLibVersionLowerBound() {
        return this.getXbaseLibVersionLowerBound();
    }

    public String getEcoreModelPath() {
        return this.ecoreModelPath;
    }

    @Override
    public IXtextGeneratorFileSystemAccess getEcoreModel() {
        return this.ecoreModel;
    }
}

