/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.editor.outline;

import com.google.inject.BindingAnnotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.editor.outline.actions.AbstractToggleOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.xtext.ui.Activator;
import org.eclipse.xtext.xtext.ui.editor.outline.Messages;

public class HideReturnTypesContribution
extends AbstractToggleOutlineContribution {
    public static final String PREFERENCE_KEY = "ui.outline.showReturnTypes";
    private TreeViewer treeViewer;

    protected void configureAction(Action action) {
        action.setText(Messages.HideReturnTypesAction_title);
        action.setToolTipText(Messages.HideReturnTypesAction_tooltip);
        action.setDescription(Messages.HideReturnTypesAction_description);
        action.setImageDescriptor(Activator.getImageDescriptor("icons/filter_rule.gif"));
        action.setDisabledImageDescriptor(Activator.getImageDescriptor("icons/filter_rule.gif"));
    }

    public String getPreferenceKey() {
        return PREFERENCE_KEY;
    }

    protected void stateChanged(boolean newState) {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh(true);
        }
    }

    public void register(OutlinePage outlinePage) {
        super.register(outlinePage);
        this.treeViewer = outlinePage.getTreeViewer();
    }

    public void deregister(OutlinePage outlinePage) {
        this.treeViewer = null;
        super.deregister(outlinePage);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface Annotation {
    }
}

