/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.wizard.ecore2xtext;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.xtext.wizard.EPackageInfo;

public class UniqueNameUtil {
    private static final String IMPL_NAME_SUFFIX = "_Impl";
    private static Map<ENamedElement, String> element2uniqueName = new HashMap<ENamedElement, String>();
    private static Map<ENamedElement, String> element2uniqueImplName = new HashMap<ENamedElement, String>();
    private static final List<String> RESERVED_RULES = Arrays.asList("ml_comment", "id", "ws", "int", "string", "any_other", "sl_comment");
    private static final List<String> RESERVED_KEYWORDS = Arrays.asList("returns", "generate", "terminal", "with", "hidden", "enum", "grammar", "import", "as", "current", "fragment", "EOF");

    public static String uniqueName(ENamedElement element) {
        String name = element.getName();
        if (name == null) {
            name = element.eClass().getName();
        }
        return UniqueNameUtil.uniqueName(element, name, element2uniqueName);
    }

    public static String uniqueImplName(ENamedElement element) {
        String name = element.getName();
        if (name == null) {
            name = element.eClass().getName();
        }
        return UniqueNameUtil.uniqueName(element, name + IMPL_NAME_SUFFIX, element2uniqueImplName);
    }

    private static String uniqueName(ENamedElement element, String originalName, Map<ENamedElement, String> uniqueNameMap) {
        if (uniqueNameMap.containsKey(element)) {
            return uniqueNameMap.get(element);
        }
        Object uniqueName = originalName;
        int i = 0;
        while (RESERVED_KEYWORDS.contains(uniqueName) || RESERVED_RULES.contains(((String)uniqueName).toLowerCase()) || element2uniqueName.containsValue(uniqueName) || element2uniqueImplName.containsValue(uniqueName)) {
            uniqueName = originalName + i;
            ++i;
        }
        uniqueNameMap.put(element, (String)uniqueName);
        return uniqueName;
    }

    public static void clearUniqueNames(EPackageInfo defaultPackageInfo) {
        element2uniqueName.clear();
        element2uniqueImplName.clear();
        if (defaultPackageInfo != null) {
            element2uniqueName.put((ENamedElement)defaultPackageInfo.getEPackage(), null);
        }
    }

    public static EClassifier eString() {
        return EcorePackage.eINSTANCE.getEString();
    }

    public static void debug(String s) {
        System.out.println(s);
    }
}

