/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples.ui.wizard;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.Messages;
import org.eclipse.m2m.internal.qvt.oml.samples.ui.SampleProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SamplesWizardPage
extends WizardPage {
    private Text[] myNames;
    private final SampleProject[] myProjects;

    public SamplesWizardPage(SampleProject[] projects) {
        super("wizardPage");
        if (projects.length == 0) {
            throw new IllegalArgumentException("No projects");
        }
        this.setTitle(Messages.SamplesWizardPage_title);
        this.setDescription(Messages.SamplesWizardPage_desc);
        this.myProjects = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.doCreateContents(container);
        this.setPageComplete(this.validatePage());
    }

    protected void doCreateContents(Composite container) {
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SamplesWizardPage.this.setPageComplete(SamplesWizardPage.this.validatePage());
            }
        };
        this.myNames = new Text[this.myProjects.length];
        int i = 0;
        while (i < this.myProjects.length) {
            SampleProject project = this.myProjects[i];
            Label label = new Label(container, 0);
            if (project.getLabel() != null) {
                label.setText(project.getLabel());
            } else {
                label.setText(NLS.bind((String)Messages.SamplesWizardPage_projectNameIndexed, (Object)new Integer(i + 1)));
            }
            Text name = new Text(container, 2052);
            name.setLayoutData((Object)new GridData(768));
            name.setText(project.getName());
            name.setSelection(name.getCharCount());
            name.setData((Object)project);
            name.addModifyListener(modifyListener);
            this.myNames[i] = name;
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.myNames != null) {
            this.myNames[0].setFocus();
        }
    }

    private boolean projectExists(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).exists();
    }

    protected boolean validatePage() {
        this.setMessage(null);
        this.setErrorMessage(null);
        int i = 0;
        while (i < this.myNames.length) {
            Text name = this.myNames[i];
            if (this.projectExists(name.getText())) {
                this.setErrorMessage(NLS.bind((String)Messages.SamplesWizardPage_alreadyExists, (Object)name.getText()));
                return false;
            }
            this.myProjects[i].setName(name.getText());
            ++i;
        }
        return true;
    }
}

