/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionEnd;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public abstract class AbstractConnection<CE extends ConnectionEnd>
implements DatumConnection,
GraphStringBuilder.GraphEdge,
GraphStringBuilder.GraphNode {
    protected final @NonNull ScheduledRegion region;
    protected final @NonNull String name;
    private ConnectionRole connectionRole;
    protected @NonNull Set<@NonNull CE> sourceEnds;
    protected final @NonNull Map<@NonNull CE, @NonNull ConnectionRole> targetEnd2role = new HashMap<CE, ConnectionRole>();
    private final @NonNull List<@NonNull Integer> indexes = new ArrayList<Integer>();

    protected AbstractConnection(@NonNull ScheduledRegion region, @NonNull Set<@NonNull CE> sourceEnds, @NonNull SymbolNameBuilder symbolNameBuilder) {
        this.region = region;
        this.name = region.getSchedulerConstants().reserveSymbolName(symbolNameBuilder, this);
        this.sourceEnds = sourceEnds;
    }

    @Override
    public boolean addIndex(int index) {
        int i = 0;
        while (i < this.indexes.size()) {
            Integer anIndex = this.indexes.get(i);
            if (index == anIndex) {
                return false;
            }
            if (index < anIndex) {
                this.indexes.add(i, index);
                return true;
            }
            ++i;
        }
        this.indexes.add(index);
        return true;
    }

    public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode target) {
        String arrowhead;
        s.setColor(this.getColor());
        String style = this.getStyle();
        if (style != null) {
            s.setStyle(style);
        }
        if ((arrowhead = this.getArrowhead()) != null) {
            s.setArrowhead(arrowhead);
        }
        s.setPenwidth(this.getPenwidth());
        s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
    }

    public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
        String name = this.getName();
        String indexText = this.getIndexText();
        if (indexText != null) {
            name = String.valueOf(name) + "\\n " + indexText;
        }
        s.setLabel(name);
        s.setShape(this.getShape());
        String style = this.getStyle();
        if (style != null) {
            s.setStyle(style);
        }
        s.setColor(this.getColor());
        s.setPenwidth(this.getPenwidth());
        s.appendAttributedNode(nodeName);
    }

    protected @Nullable ConnectionRole basicGetConnectionRole() {
        return this.connectionRole;
    }

    @Override
    public void destroy() {
        this.region.removeConnection(this);
    }

    @Override
    public String getArrowhead() {
        return this.getConnectionRole().getArrowhead();
    }

    @Override
    public @NonNull String getColor() {
        return this.getConnectionRole().getColor();
    }

    public @NonNull ConnectionRole getConnectionRole(@NonNull CE targetEnd) {
        ConnectionRole connectionRole = this.targetEnd2role.get(targetEnd);
        assert (connectionRole != null);
        return connectionRole;
    }

    @Override
    public @NonNull ConnectionRole getConnectionRole() {
        assert (this.connectionRole != null);
        return this.connectionRole;
    }

    public @Nullable String getIndexText() {
        StringBuilder s = null;
        for (Integer index : this.indexes) {
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(",");
            }
            s.append(index.toString());
        }
        return s != null ? s.toString() : null;
    }

    @Override
    public @NonNull List<@NonNull Integer> getIndexes() {
        return this.indexes;
    }

    @Override
    public @NonNull String getLabel() {
        return this.name;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Integer getPenwidth() {
        Integer penwidth = this.getConnectionRole().getPenwidth();
        return penwidth;
    }

    @Override
    public @NonNull ScheduledRegion getRegion() {
        return this.region;
    }

    public @NonNull String getShape() {
        return "ellipse";
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getSource() {
        throw new UnsupportedOperationException();
    }

    public @NonNull CE getSource(@NonNull Region sourceRegion) {
        @Nullable ConnectionEnd sourceEnd = null;
        for (ConnectionEnd end : this.sourceEnds) {
            if (end.getRegion() != sourceRegion) continue;
            assert (sourceEnd == null);
            sourceEnd = end;
        }
        assert (sourceEnd != null);
        return (CE)sourceEnd;
    }

    @Override
    public @NonNull String getSourceDisplayNames() {
        StringBuilder s = new StringBuilder();
        for (ConnectionEnd source : this.getSources()) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(source.getDisplayName());
        }
        return s.toString();
    }

    public @NonNull Set<@NonNull Region> getSourceRegions() {
        HashSet<@NonNull Region> sourceRegions = new HashSet<Region>();
        for (ConnectionEnd sourceEnd : this.getSources()) {
            Region sourceRegion = sourceEnd.getRegion();
            sourceRegions.add(sourceRegion);
        }
        return sourceRegions;
    }

    @Override
    public @NonNull Iterable<@NonNull Region> getSourceRegions(@NonNull ScheduledRegion scheduledRegion) {
        HashSet<@NonNull Region> sourceRegions = new HashSet<Region>();
        for (ConnectionEnd sourceEnd : this.getSources()) {
            Region sourceRegion = sourceEnd.getRegion();
            if ((sourceRegion = scheduledRegion.getNormalizedRegion(sourceRegion)) == null) continue;
            sourceRegions.add(sourceRegion);
        }
        return sourceRegions;
    }

    public @NonNull Iterable<@NonNull CE> getSources() {
        return this.sourceEnds;
    }

    public @Nullable String getStyle() {
        return this.getConnectionRole().getStyle();
    }

    @Override
    public @NonNull String getSymbolName() {
        return this.name;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode getTarget() {
        throw new UnsupportedOperationException();
    }

    public @NonNull CE getTarget(@NonNull Region targetRegion) {
        @Nullable ConnectionEnd targetEnd = null;
        for (ConnectionEnd end : this.targetEnd2role.keySet()) {
            if (end.getRegion() != targetRegion) continue;
            assert (targetEnd == null);
            targetEnd = end;
        }
        assert (targetEnd != null);
        return (CE)targetEnd;
    }

    public @NonNull Set<@NonNull Region> getTargetRegions() {
        HashSet<@NonNull Region> targetRegions = new HashSet<Region>();
        for (ConnectionEnd targetEnd : this.getTargets().keySet()) {
            Region targetRegion = targetEnd.getRegion();
            targetRegions.add(targetRegion);
        }
        return targetRegions;
    }

    @Override
    public @NonNull Iterable<@NonNull Region> getTargetRegions(@NonNull ScheduledRegion scheduledRegion) {
        HashSet<@NonNull Region> targetRegions = new HashSet<Region>();
        for (ConnectionEnd targetEnd : this.getTargets().keySet()) {
            Region targetRegion = targetEnd.getRegion();
            if ((targetRegion = scheduledRegion.getNormalizedRegion(targetRegion)) == null) continue;
            targetRegions.add(targetRegion);
        }
        return targetRegions;
    }

    @Override
    public @NonNull Map<@NonNull ? extends ConnectionEnd, @NonNull ConnectionRole> getTargets() {
        return this.targetEnd2role;
    }

    private boolean isRegion2Region(@NonNull Map<Region, Integer> sourceRegion2count, @NonNull Map<@NonNull Region, @NonNull List<@NonNull ConnectionRole>> targetRegion2roles) {
        return sourceRegion2count.size() == 1 && targetRegion2roles.size() == 1 && targetRegion2roles.values().iterator().next().size() == 1;
    }

    protected void mergeRole(@NonNull ConnectionRole connectionRole) {
        if (this.connectionRole == null) {
            this.connectionRole = connectionRole;
        } else if (this.connectionRole != connectionRole) {
            this.connectionRole = this.connectionRole.merge(connectionRole);
        }
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.appendEdge(this.getSource(), (GraphStringBuilder.GraphEdge)this, this.getTarget());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void toRegionGraph(@NonNull ScheduledRegion scheduledRegion, @NonNull GraphStringBuilder s) {
        HashMap<@NonNull Region, @NonNull Integer> sourceRegion2count = new HashMap<Region, Integer>();
        for (Node source : this.getSourceNodes()) {
            Region sourceRegion = scheduledRegion.getNormalizedRegion(source.getRegion());
            if (sourceRegion == null) continue;
            sourceRegion2count.put(sourceRegion, 1);
        }
        HashMap<@NonNull Region, @NonNull List<@NonNull ConnectionRole>> targetRegion2roles = new HashMap<Region, List<ConnectionRole>>();
        for (ConnectionEnd target : this.targetEnd2role.keySet()) {
            ConnectionRole role = this.targetEnd2role.get(target);
            assert (role != null);
            Region targetRegion = scheduledRegion.getNormalizedRegion(target.getRegion());
            if (targetRegion == null) continue;
            ArrayList<@NonNull ConnectionRole> roles = (ArrayList<ConnectionRole>)targetRegion2roles.get(targetRegion);
            if (roles == null) {
                roles = new ArrayList<ConnectionRole>();
                targetRegion2roles.put(targetRegion, roles);
            }
            if (roles.contains(role)) continue;
            roles.add(role);
        }
        if (this.isRegion2Region(sourceRegion2count, targetRegion2roles)) {
            Region sourceRegion = (Region)sourceRegion2count.keySet().iterator().next();
            Iterator targetRegion = (Region)targetRegion2roles.keySet().iterator().next();
            s.appendEdge((GraphStringBuilder.GraphNode)sourceRegion, (GraphStringBuilder.GraphEdge)this, targetRegion);
        } else {
            s.appendNode((GraphStringBuilder.GraphNode)this);
            for (Region sourceRegion : sourceRegion2count.keySet()) {
                Integer counts = (Integer)sourceRegion2count.get(sourceRegion);
                assert (counts != null);
                int i = counts;
                while (i > 0) {
                    s.appendEdge((GraphStringBuilder.GraphNode)sourceRegion, (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)this);
                    --i;
                }
            }
            for (Region targetRegion : targetRegion2roles.keySet()) {
                @NonNull List roles = (List)targetRegion2roles.get(targetRegion);
                assert (roles != null);
                for (ConnectionRole role : roles) {
                    s.appendEdge((GraphStringBuilder.GraphNode)this, (GraphStringBuilder.GraphEdge)role, (GraphStringBuilder.GraphNode)targetRegion);
                }
            }
            Node headNode = null;
            if (sourceRegion2count.size() == 0) {
                Node node;
                ConnectionEnd sourceEnd = null;
                for (ConnectionEnd end : this.sourceEnds) {
                    if (end.getRegion() != scheduledRegion) continue;
                    assert (sourceEnd == null);
                    sourceEnd = end;
                }
                if (sourceEnd instanceof Node && (node = (Node)sourceEnd).isHead()) {
                    headNode = node;
                    s.appendEdge((GraphStringBuilder.GraphNode)headNode, (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)this);
                }
            }
        }
    }

    public String toString() {
        return this.getSymbolName();
    }

    public String toString2() {
        StringBuilder s = new StringBuilder();
        ConnectionRole connectionRole = this.basicGetConnectionRole();
        if (connectionRole != null) {
            s.append(connectionRole);
        }
        s.append(this.getName());
        s.append("(");
        boolean isFirst = true;
        for (ConnectionEnd sourceEnd : this.sourceEnds) {
            if (!isFirst) {
                s.append(",");
            }
            s.append(sourceEnd.getDisplayName());
            isFirst = false;
        }
        s.append(" => ");
        isFirst = true;
        for (ConnectionEnd targetEnd : this.targetEnd2role.keySet()) {
            if (!isFirst) {
                s.append(",");
            }
            ConnectionRole targetConnectionRole = this.targetEnd2role.get(targetEnd);
            s.append(targetConnectionRole);
            s.append(targetEnd.getDisplayName());
            isFirst = false;
        }
        s.append(")");
        return s.toString();
    }
}

