/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.emf.appearance.helper.AppearanceHelper;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public abstract class StereotypedElementLabelHelper {
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";

    public Element getUMLElement(GraphicalEditPart editPart) {
        return UMLUtil.resolveUMLElement((Object)editPart);
    }

    protected Map<String, List<String>> parseStereotypeProperties(GraphicalEditPart editPart, String stereotypesToDisplay, String stereotypesPropertiesToDisplay) {
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        if (stereotypesPropertiesToDisplay != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(stereotypesPropertiesToDisplay, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String propertyName = stringTokenizer.nextToken();
                String stereotypeName = propertyName.substring(0, propertyName.lastIndexOf("."));
                if (!propertiesMap.containsKey(stereotypeName)) {
                    ArrayList propertiesForStereotype = new ArrayList();
                    propertiesMap.put(stereotypeName, propertiesForStereotype);
                }
                ((List)propertiesMap.get(stereotypeName)).add(propertyName.substring(propertyName.lastIndexOf(".") + 1, propertyName.length()));
            }
        }
        return propertiesMap;
    }

    public Collection<Image> stereotypeIconsToDisplay(GraphicalEditPart editPart) {
        String stereotypespresentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)((View)editPart.getModel()));
        if (stereotypespresentationKind == null) {
            return null;
        }
        if (stereotypespresentationKind.equals("IconStereotype") || stereotypespresentationKind.equals("TextIconStereotype")) {
            ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
            for (Stereotype appliedStereotype : this.getUMLElement(editPart).getAppliedStereotypes()) {
                if (!(editPart.getModel() instanceof View) || !StereotypeDisplayUtil.getInstance().getStereotypeLabel((View)editPart.getModel(), appliedStereotype).isVisible()) continue;
                stereotypes.add(appliedStereotype);
            }
            return Activator.getIconElements(this.getUMLElement(editPart), stereotypes, false);
        }
        return new ArrayList<Image>();
    }

    public String stereotypesToDisplay(GraphicalEditPart editPart) {
        View view = (View)editPart.getModel();
        String stereotypesToDisplay = StereotypeDisplayUtil.getInstance().getStereotypeTextToDisplay(view);
        String stereotypesPropertiesToDisplay = StereotypeDisplayUtil.getInstance().getStereotypePropertiesInBrace(view);
        Object display = EMPTY_STRING;
        if (stereotypesToDisplay != null && !stereotypesToDisplay.equals(EMPTY_STRING)) {
            display = (String)display + stereotypesToDisplay + SPACE;
        }
        if (stereotypesPropertiesToDisplay != null && !stereotypesPropertiesToDisplay.equals(EMPTY_STRING)) {
            display = (String)display + "{" + stereotypesPropertiesToDisplay + "} ";
        }
        return display;
    }

    public void refreshEditPartDisplay(GraphicalEditPart editPart) {
        IFigure figure = editPart.getFigure();
        Collection<Image> imageToDisplay = this.stereotypeIconsToDisplay(editPart);
        if (AppearanceHelper.showElementIcon((EModelElement)((View)editPart.getModel()))) {
            imageToDisplay.add(this.getImage(editPart));
        }
        int i = 0;
        if (figure instanceof WrappingLabel) {
            while (((WrappingLabel)figure).getIcon(i) != null) {
                ((WrappingLabel)figure).setIcon(null, i);
                ++i;
            }
            i = 0;
            for (Image image : imageToDisplay) {
                ((WrappingLabel)figure).setIcon(image, i);
                ++i;
            }
            ((WrappingLabel)figure).setText(this.labelToDisplay(editPart));
        }
    }

    protected String labelToDisplay(GraphicalEditPart editPart) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stereotypesToDisplay(editPart));
        buffer.append(this.elementLabel(editPart));
        return buffer.toString();
    }

    protected abstract String elementLabel(GraphicalEditPart var1);

    public Image getImage(GraphicalEditPart editPart) {
        Element element = this.getUMLElement(editPart);
        String key = null;
        if (element instanceof NamedElement) {
            StringBuilder builder = new StringBuilder();
            if (((NamedElement)element).getName() == null) {
                builder.append(element.getClass().getName());
            } else {
                builder.append(((NamedElement)element).getName());
            }
            builder.append("::");
            builder.append(((NamedElement)element).getVisibility());
            key = builder.toString();
        } else if (element != null) {
            key = element.getClass().getName();
        } else {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(key);
        ImageDescriptor descriptor = null;
        if (image == null) {
            AdapterFactory factory = Activator.getDefault().getItemProvidersAdapterFactory();
            IItemLabelProvider labelProvider = (IItemLabelProvider)factory.adapt((Notifier)this.getUMLElement(editPart), IItemLabelProvider.class);
            if (labelProvider != null) {
                descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)this.getUMLElement(editPart)));
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(key, descriptor);
            image = imageRegistry.get(key);
        }
        return image;
    }
}

