/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.dialog;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.Theme;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFContentProvider;
import org.eclipse.papyrus.infra.ui.util.PapyrusImageUtils;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.WorkspaceContentProvider;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class CSSThemeCreationDialog
extends Dialog {
    private static final String ICON_SELECTION_DIALOG_TITLE = "Icon selection";
    private static final String WORKSPACE_MENU_LABEL = "Workspace";
    private static final String FILE_SYSTEM_MENU_LABEL = "File System";
    private static final int FILESYSTEM_MENU_ID = 15;
    private static final int WORKSPACE_MENU_ID = 12;
    private static final String BROWSE_BUTTON_LABEL = "Browse...";
    private static List<String> filterExtensions = Arrays.asList("*.gif;*.png;*.jpeg", "*.gif", "*.png", "*.jpeg");
    private List<String> filterNames = Arrays.asList("All images", "GIF Icon", "PNG Icon", "JPEG Icon");
    private static final String DIALOG_TITLE = "CSS Theme Definition";
    private static final String ICON_PATH_LABEL = "Icon";
    private static final String THEME_NAME_LABEL = "Label";
    private static final int BROWSE_BUTTON_ID = 13;
    private Theme theme = null;
    private Text themeLabelField = null;
    private Text iconPathField = null;
    private TreeViewer styleSheetsViewer = null;
    private Menu browseMenu = null;

    public CSSThemeCreationDialog(Shell parentShell, Theme theme) {
        super(parentShell);
        this.theme = theme;
        this.initialiseFilterLabels(this.filterNames, filterExtensions);
    }

    private void initialiseFilterLabels(List<String> filterNames, List<String> filterExtensions) {
        int size = Math.min(filterNames.size(), filterExtensions.size());
        String[] filters = new String[size];
        int i = 0;
        while (i < size) {
            filters[i] = filterNames.get(i) + " (" + filterExtensions.get(i) + ")";
            ++i;
        }
        this.filterNames = Arrays.asList(filters);
    }

    protected Point getInitialSize() {
        return new Point(320, 360);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
        newShell.setImage(PapyrusImageUtils.getDefaultIcon());
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        this.createThemeLabelPart(mainComposite);
        this.createThemeIconPart(mainComposite);
        this.createStyleSheetsTreeComposite(mainComposite);
        this.initialiseTree();
        return mainComposite;
    }

    private void createThemeLabelPart(Composite parent) {
        Label themeNameLabel = new Label(parent, 0);
        themeNameLabel.setText(THEME_NAME_LABEL);
        this.themeLabelField = new Text(parent, 2048);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.horizontalSpan = 2;
        this.themeLabelField.setLayoutData((Object)layoutData);
        this.themeLabelField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSSThemeCreationDialog.this.theme.setLabel(CSSThemeCreationDialog.this.themeLabelField.getText());
            }
        });
    }

    private void createThemeIconPart(Composite parent) {
        Label themeIconLabel = new Label(parent, 0);
        themeIconLabel.setText(ICON_PATH_LABEL);
        this.iconPathField = new Text(parent, 2048);
        this.iconPathField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.iconPathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CSSThemeCreationDialog.this.theme.setIcon(CSSThemeCreationDialog.this.iconPathField.getText());
            }
        });
        Button browseButton = this.createButton(parent, 13, BROWSE_BUTTON_LABEL, false);
        this.browseMenu = new Menu((Control)browseButton);
        this.createMenuItem(this.browseMenu, FILE_SYSTEM_MENU_LABEL, 15);
        this.createMenuItem(this.browseMenu, WORKSPACE_MENU_LABEL, 12);
    }

    private void createMenuItem(Menu parentMenu, String label, int menuId) {
        MenuItem menuItem = new MenuItem(parentMenu, 0);
        menuItem.setText(label);
        menuItem.setData((Object)new Integer(menuId));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSSThemeCreationDialog.this.menuSelected((Integer)e.widget.getData());
            }
        });
    }

    private void menuSelected(int menuId) {
        switch (menuId) {
            case 12: {
                this.browseWorkspace();
                break;
            }
            case 15: {
                this.browseFileSytem();
                break;
            }
        }
    }

    private void browseFileSytem() {
        File file = this.getFile(this.iconPathField.getText());
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(ICON_SELECTION_DIALOG_TITLE);
        dialog.setFileName(file.getAbsolutePath());
        dialog.setFilterExtensions(filterExtensions.toArray(new String[filterExtensions.size()]));
        dialog.setFilterNames(this.filterNames.toArray(new String[this.filterNames.size()]));
        String result = dialog.open();
        if (result == null) {
            return;
        }
        this.setResult(result);
    }

    private void browseWorkspace() {
        Object file;
        Object[] result;
        int code;
        LabelProviderServiceImpl labelProviderService = new LabelProviderServiceImpl();
        try {
            labelProviderService.startService();
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
        ILabelProvider labelProvider = labelProviderService.getLabelProvider();
        IFile currentFile = this.getIFile(this.iconPathField.getText());
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setTitle(ICON_SELECTION_DIALOG_TITLE);
        WorkspaceContentProvider contentProvider = new WorkspaceContentProvider();
        if (!filterExtensions.isEmpty() && !this.filterNames.isEmpty()) {
            contentProvider.setExtensionFilters(new LinkedHashMap());
            int i = 0;
            while (i < Math.min(this.filterNames.size(), filterExtensions.size())) {
                contentProvider.addExtensionFilter(filterExtensions.get(i), this.filterNames.get(i));
                ++i;
            }
        }
        dialog.setContentProvider((ITreeContentProvider)contentProvider);
        dialog.setLabelProvider(labelProvider);
        if (currentFile != null && currentFile.exists()) {
            dialog.setInitialSelections((Object[])new IFile[]{currentFile});
        }
        if ((code = dialog.open()) == 0 && (result = dialog.getResult()).length > 0 && (file = result[0]) instanceof IFile) {
            this.setResult((IFile)file);
        }
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 13: {
                this.browseMenu.setVisible(true);
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void setResult(IFile file) {
        this.iconPathField.setText(file.getFullPath().toString());
    }

    protected void setResult(File file) {
        this.iconPathField.setText(file.getAbsolutePath());
    }

    protected void setResult(String path) {
        this.iconPathField.setText(path);
    }

    protected IFile getIFile(String path) {
        return FileUtil.getIFile((String)path);
    }

    protected File getFile(String path) {
        return FileUtil.getFile((String)path);
    }

    private void createStyleSheetsTreeComposite(Composite parent) {
        this.styleSheetsViewer = new TreeViewer(parent, 2048);
        Tree tree = this.styleSheetsViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
    }

    private void initialiseTree() {
        this.styleSheetsViewer.setContentProvider((IContentProvider)new EMFContentProvider((EObject)this.theme, (EStructuralFeature)StylesheetsPackage.eINSTANCE.getTheme_Stylesheets()){

            protected IStructuredContentProvider getSemanticProvider(final EObject editedEObject, EStructuralFeature feature) {
                return new AbstractStaticContentProvider(){

                    public Object[] getElements() {
                        LinkedList result = new LinkedList();
                        if (editedEObject instanceof Theme) {
                            result.addAll((this).CSSThemeCreationDialog.this.theme.getStylesheets());
                        }
                        return result.toArray();
                    }
                };
            }
        });
        this.styleSheetsViewer.setLabelProvider((IBaseLabelProvider)new StyleSheetLabelProvider());
        this.styleSheetsViewer.setInput((Object)this.theme.getStylesheets());
    }

    private class StyleSheetLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String text = element.toString();
            if (element instanceof StyleSheetReference) {
                text = ((StyleSheetReference)element).getPath();
            }
            return text;
        }
    }
}

