/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.views.validation.internal.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.MarkerResolutionSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;

public class QuickFixHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IMarker marker;
        IStructuredSelection sel;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !(sel = (IStructuredSelection)selection).isEmpty() && (marker = (IMarker)AdapterUtils.adapt((Object)sel.getFirstElement(), IMarker.class, null)) != null && IDE.getMarkerHelpRegistry().hasResolutions(marker)) {
            Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            IMarkerResolution toRun = null;
            IMarkerResolution[] resolutions = IDE.getMarkerHelpRegistry().getResolutions(marker);
            switch (resolutions.length) {
                case 0: {
                    MessageDialog.openInformation((Shell)shell, (String)"Quick Fix", (String)"No quick fixes are available for the selected problem.");
                    break;
                }
                case 1: {
                    toRun = resolutions[0];
                    break;
                }
                default: {
                    MarkerResolutionSelectionDialog dlg = new MarkerResolutionSelectionDialog(shell, resolutions);
                    if (dlg.open() != 0) break;
                    Object[] result = dlg.getResult();
                    IMarkerResolution iMarkerResolution = toRun = result != null && result.length > 0 ? (IMarkerResolution)result[0] : null;
                }
            }
            if (toRun != null) {
                this.runQuickFix(toRun, marker, HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event));
            }
        }
        return null;
    }

    void runQuickFix(final IMarkerResolution fix, final IMarker marker, IWorkbenchWindow window) {
        try {
            window.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    fix.run(marker);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.log.error((Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.log.error((Throwable)e);
        }
    }
}

