/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.languageexpression.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.controllers.IEEFWidgetController;
import org.eclipse.eef.ide.ui.api.widgets.AbstractEEFWidgetLifecycleManager;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.EEFExtReferenceUIPlugin;
import org.eclipse.eef.ide.ui.ext.widgets.reference.internal.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.sirius.properties.eef.advanced.controls.eefadvancedcontrols.EEFLanguageExpressionDescription;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.Activator;
import org.eclipse.papyrus.sirius.properties.uml.eef.ide.ui.advanced.controls.languageexpression.internal.LanguageExpressionController;
import org.eclipse.papyrus.uml.properties.expression.ExpressionList;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.properties.preferences.LanguageRegistry;
import org.eclipse.papyrus.uml.properties.widgets.DynamicBodyEditor;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.uml2.uml.BodyOwner;

public class LanguageExpressionLifecycleManager
extends AbstractEEFWidgetLifecycleManager {
    private static final int INVALID_SELECTION_INDEX = -1;
    private static final String EDIT_BUTTON_TOOLTIP = "Edit the selected value";
    private static final String DEFAULT_BODY_STRING = "";
    private static final String ADD_LANGUAGE_DIALOG_MESSAGE = "Create a new Language";
    private static final String ADD_LANGUAGE_DIALOG_TITLE = "New Language";
    private static final String BROWSE_LANGUAGES_DIALOG_TITLE = "Language";
    private static final String EDIT_LANGUAGE_DIALOG_MESSAGE = "Edit the value of the Language";
    private static final String EDIT_LANGUAGE_DIALOG_TITLE = "Edit Language";
    private ComposedAdapterFactory composedAdapterFactory;
    private EEFLanguageExpressionDescription description;
    private LanguageExpressionController controller;
    private Composite mainComposite;
    private TableViewer tableViewer;
    private DynamicBodyEditor bodyEditor;
    private Button upButton;
    private Button downButton;
    private Button browseButton;
    private Button addButton;
    private Button removeButton;
    private Button editButton;
    private ButtonSelectionListener upButtonListener;
    private ButtonSelectionListener downButtonListener;
    private ButtonSelectionListener browseButtonListener;
    private ButtonSelectionListener addButtonListener;
    private ButtonSelectionListener removeButtonListener;
    private ButtonSelectionListener editButtonListener;
    private IDoubleClickListener tableDoubleClickListener;
    private ISelectionChangedListener tableSelectionChangedListener;
    private BodyOwner target;
    private ExpressionList.Expression currentExpression;

    public LanguageExpressionLifecycleManager(EEFLanguageExpressionDescription controlDescription, BodyOwner target, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter editingContextAdapter) {
        super(variableManager, interpreter, editingContextAdapter);
        this.description = controlDescription;
        this.target = target;
    }

    protected void createMainControl(Composite parent, IEEFFormContainer formContainer) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout(2, false);
        this.mainComposite.setLayout((Layout)mainLayout);
        GridData mainLayoutData = new GridData(4, 0x1000000, true, false);
        this.mainComposite.setLayoutData((Object)mainLayoutData);
        this.createLanguageEditor(this.mainComposite);
        this.createBodyEditor(this.mainComposite);
        this.controller = new LanguageExpressionController(this.description, this.variableManager, this.interpreter, this.editingContextAdapter);
    }

    protected void createLanguageEditor(Composite parent) {
        Composite languageEditorComposite = new Composite(parent, 0);
        GridLayout languageEditorLayout = new GridLayout(2, false);
        languageEditorComposite.setLayout((Layout)languageEditorLayout);
        GridData languageEditorlayoutData = new GridData(4, 0x1000000, false, false);
        languageEditorComposite.setLayoutData((Object)languageEditorlayoutData);
        int style = 0x10000008;
        int selectionStyle = 65540;
        int tableStyle = 2560;
        style = style | selectionStyle | tableStyle;
        Table table = new Table(languageEditorComposite, style);
        GridData tableGridData = new GridData(4, 128, false, false, 1, 1);
        tableGridData.widthHint = 150;
        table.setLayoutData((Object)tableGridData);
        this.tableViewer = new TableViewer(table);
        this.composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.composedAdapterFactory, (Viewer)this.tableViewer)));
        this.tableViewer.setInput(this.getExpressionsList());
        this.tableSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection structuredSelection;
                ExpressionList.Expression selectedExpression;
                if (LanguageExpressionLifecycleManager.this.tableViewer.getSelection() instanceof IStructuredSelection && (selectedExpression = (ExpressionList.Expression)(structuredSelection = (IStructuredSelection)LanguageExpressionLifecycleManager.this.tableViewer.getSelection()).getFirstElement()) != LanguageExpressionLifecycleManager.this.currentExpression) {
                    LanguageExpressionLifecycleManager.this.currentExpression = selectedExpression;
                    LanguageExpressionLifecycleManager.this.bodyEditor.display(selectedExpression);
                }
                LanguageExpressionLifecycleManager.this.setEnabled(LanguageExpressionLifecycleManager.this.isEnabled());
            }
        };
        this.tableDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (LanguageExpressionLifecycleManager.this.isEnabled()) {
                    LanguageExpressionLifecycleManager.this.editingContextAdapter.performModelChange(() -> LanguageExpressionLifecycleManager.this.editButtonCallback());
                }
            }
        };
        this.tableViewer.addSelectionChangedListener(this.tableSelectionChangedListener);
        this.tableViewer.addDoubleClickListener(this.tableDoubleClickListener);
        Composite buttonsComposite = this.createButtons(languageEditorComposite);
        Point computedSize = buttonsComposite.computeSize(-1, -1);
        tableGridData.heightHint = computedSize.y - table.getItemHeight();
    }

    protected Composite createButtons(Composite parent) {
        Composite buttonsComposite = new Composite(parent, 0);
        GridLayout buttonCompositeGridLayout = new GridLayout(1, false);
        buttonCompositeGridLayout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)buttonCompositeGridLayout);
        GridData buttonCompositeGridData = new GridData(0x1000000, 0x1000000, false, false);
        buttonsComposite.setLayoutData((Object)buttonCompositeGridData);
        Image upImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowUp_16x16.gif"));
        Image downImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/ArrowDown_16x16.gif"));
        Image browseImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Browse_16x16.gif"));
        Image addImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Add_16x16.gif"));
        Image removeImage = ExtendedImageRegistry.INSTANCE.getImage(EEFExtReferenceUIPlugin.getPlugin().getImage("full16/Delete_16x16.gif"));
        Image editImage = ExtendedImageRegistry.INSTANCE.getImage((Object)Activator.getDefault().getImage("Edit_16x16.gif"));
        this.upButton = this.createButton(buttonsComposite, upImage);
        this.downButton = this.createButton(buttonsComposite, downImage);
        this.browseButton = this.createButton(buttonsComposite, browseImage);
        this.addButton = this.createButton(buttonsComposite, addImage);
        this.removeButton = this.createButton(buttonsComposite, removeImage);
        this.editButton = this.createButton(buttonsComposite, editImage);
        return buttonsComposite;
    }

    protected void createBodyEditor(Composite parent) {
        this.bodyEditor = new DynamicBodyEditor(parent, 0);
        GridLayout bodyEditorLayout = new GridLayout(1, false);
        this.bodyEditor.setLayout((Layout)bodyEditorLayout);
        GridData bodyEditorlayoutData = new GridData(4, 4, true, false);
        this.bodyEditor.setLayoutData((Object)bodyEditorlayoutData);
        this.bodyEditor.setContext((ModelElement)new UMLModelElement((EObject)this.target));
        this.bodyEditor.addChangeListener(new Listener(){

            public void handleEvent(Event event) {
                String newValue = LanguageExpressionLifecycleManager.this.bodyEditor.getValue();
                if (LanguageExpressionLifecycleManager.this.currentExpression != null) {
                    if (newValue == null || LanguageExpressionLifecycleManager.this.currentExpression.getBody().equals(newValue)) {
                        return;
                    }
                    LanguageExpressionLifecycleManager.this.editingContextAdapter.performModelChange(() -> {
                        LanguageExpressionLifecycleManager.this.target.getBodies().set(LanguageExpressionLifecycleManager.this.expressionIndex(LanguageExpressionLifecycleManager.this.currentExpression), (Object)newValue);
                        LanguageExpressionLifecycleManager.this.currentExpression.setBody(newValue);
                    });
                }
            }
        });
    }

    protected Button createButton(Composite parent, Image image) {
        Button button = new Button(parent, 0);
        button.setImage(image);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected IEEFWidgetController getController() {
        return this.controller;
    }

    protected EEFLanguageExpressionDescription getWidgetDescription() {
        return this.description;
    }

    protected Control getValidationControl() {
        return this.mainComposite;
    }

    public void refresh(int selectionIndice) {
        super.refresh();
        this.tableViewer.setInput(this.getExpressionsList());
        this.tableViewer.refresh();
        this.controller.refresh();
        List<ExpressionList.Expression> expressionsList = this.getExpressionsList();
        if (selectionIndice != -1 && selectionIndice < expressionsList.size()) {
            ExpressionList.Expression expression = expressionsList.get(selectionIndice);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)expression), true);
        } else {
            this.tableViewer.setSelection(null);
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.initializeMoveButton();
        this.initializeBrowseButton();
        this.initializeAddButton();
        this.initializeRemoveButton();
        this.initializeEditButton();
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.tableViewer != null) {
            this.tableViewer.removeSelectionChangedListener(this.tableSelectionChangedListener);
            this.tableViewer.removeDoubleClickListener(this.tableDoubleClickListener);
        }
        this.removeListener(this.upButton, this.upButtonListener);
        this.removeListener(this.downButton, this.downButtonListener);
        this.removeListener(this.browseButton, this.browseButtonListener);
        this.removeListener(this.addButton, this.addButtonListener);
        this.removeListener(this.removeButton, this.removeButtonListener);
        this.removeListener(this.editButton, this.editButtonListener);
    }

    protected void setEnabled(boolean isEnabled) {
        boolean elementIsSelected;
        Table table = this.tableViewer.getTable();
        boolean manyItems = table.getItemCount() > 1;
        TableItem[] selection = table.getSelection();
        boolean bl = elementIsSelected = selection != null && selection.length > 0;
        if (this.addButton != null && !this.addButton.isDisposed()) {
            this.addButton.setEnabled(isEnabled);
        }
        if (this.removeButton != null && !this.removeButton.isDisposed()) {
            if (elementIsSelected) {
                this.removeButton.setEnabled(isEnabled);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(isEnabled);
        }
        if (this.editButton != null && !this.editButton.isDisposed()) {
            if (elementIsSelected) {
                this.editButton.setEnabled(isEnabled);
            } else {
                this.editButton.setEnabled(false);
            }
        }
        if (this.upButton != null && !this.upButton.isDisposed()) {
            if (elementIsSelected) {
                boolean isFirstItem;
                boolean bl2 = isFirstItem = table.indexOf(selection[0]) <= 0;
                if (manyItems && !isFirstItem) {
                    this.upButton.setEnabled(isEnabled);
                } else {
                    this.upButton.setEnabled(false);
                }
            } else {
                this.upButton.setEnabled(false);
            }
        }
        if (this.downButton != null && !this.downButton.isDisposed()) {
            if (elementIsSelected) {
                boolean isLastItem;
                boolean bl3 = isLastItem = table.indexOf(selection[0]) >= table.getItemCount() - 1;
                if (manyItems && !isLastItem) {
                    this.downButton.setEnabled(isEnabled);
                } else {
                    this.downButton.setEnabled(false);
                }
            } else {
                this.downButton.setEnabled(false);
            }
        }
    }

    protected void initializeMoveButton() {
        this.upButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.moveButtonCallback(Direction.UP));
        this.upButton.addSelectionListener((SelectionListener)this.upButtonListener);
        this.upButton.setToolTipText(Messages.ReferenceUpButton_tooltipText);
        this.downButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.moveButtonCallback(Direction.DOWN));
        this.downButton.addSelectionListener((SelectionListener)this.downButtonListener);
        this.downButton.setToolTipText(Messages.ReferenceDownButton_tooltipText);
    }

    protected void initializeBrowseButton() {
        this.browseButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.browseButtonCallback());
        this.browseButton.addSelectionListener((SelectionListener)this.browseButtonListener);
        this.browseButton.setToolTipText(Messages.ReferenceBrowseButton_tooltipText);
    }

    protected void initializeAddButton() {
        this.addButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.addButtonCallback());
        this.addButton.addSelectionListener((SelectionListener)this.addButtonListener);
        this.addButton.setToolTipText(Messages.ReferenceAddButton_tooltipText);
    }

    protected void initializeRemoveButton() {
        this.removeButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.removeButtonCallback());
        this.removeButton.addSelectionListener((SelectionListener)this.removeButtonListener);
        this.removeButton.setToolTipText(Messages.ReferenceRemoveButton_containmentTooltipText);
    }

    protected void initializeEditButton() {
        this.editButtonListener = new ButtonSelectionListener(this.editingContextAdapter, () -> this.editButtonCallback());
        this.editButton.addSelectionListener((SelectionListener)this.editButtonListener);
        this.editButton.setToolTipText(EDIT_BUTTON_TOOLTIP);
    }

    private void moveButtonCallback(Direction direction) {
        List<ExpressionList.Expression> selectedExpression = this.selectionToList(this.tableViewer.getSelection());
        EList languageList = this.target.getLanguages();
        EList bodyList = this.target.getBodies();
        if (selectedExpression.size() == 1) {
            int expressionIndex = this.expressionIndex(this.currentExpression);
            int newExpressionIndex = direction == Direction.UP ? Math.max(0, expressionIndex - 1) : Math.min(languageList.size() - 1, expressionIndex + 1);
            languageList.move(newExpressionIndex, expressionIndex);
            bodyList.move(newExpressionIndex, expressionIndex);
            this.refresh(newExpressionIndex);
        }
    }

    private void browseButtonCallback() {
        ListDialog dialog = new ListDialog(Display.getCurrent().getActiveShell()){

            protected int getTableStyle() {
                int style = 0x10000008;
                int selectionStyle = 65538;
                int tableStyle = 2560;
                return style | selectionStyle | tableStyle;
            }
        };
        dialog.setTitle(BROWSE_LANGUAGES_DIALOG_TITLE);
        dialog.setInput((Object)LanguageRegistry.instance.getLanguages());
        dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider());
        int indexToSelect = -1;
        if (dialog.open() == 0) {
            Object[] selectedItems = dialog.getResult();
            ArrayList<String> addedItems = new ArrayList<String>();
            Object[] objectArray = selectedItems;
            int n = selectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                boolean alreadyExists = this.getExpressionsList().stream().anyMatch(e -> e.getLanguage().equals(item));
                if (item instanceof String && !alreadyExists) {
                    String selectedLanguage = (String)item;
                    addedItems.add(selectedLanguage);
                    this.target.getLanguages().add((Object)selectedLanguage);
                    this.target.getBodies().add((Object)DEFAULT_BODY_STRING);
                }
                ++n2;
            }
            if (addedItems.size() > 0) {
                ExpressionList.Expression firstAddedExpression = this.getExpressionsList().stream().filter(e -> e.getLanguage().equals(addedItems.get(0))).findFirst().get();
                indexToSelect = this.expressionIndex(firstAddedExpression);
            }
        } else {
            throw new OperationCanceledException();
        }
        this.refresh(indexToSelect);
    }

    private void addButtonCallback() {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), ADD_LANGUAGE_DIALOG_TITLE, ADD_LANGUAGE_DIALOG_MESSAGE, null, null);
        if (dialog.open() == 0) {
            String newLanguage = dialog.getValue();
            List<ExpressionList.Expression> expressionsList = this.getExpressionsList();
            boolean alreadyExists = expressionsList.stream().anyMatch(e -> e.getLanguage().equals(newLanguage));
            if (!alreadyExists) {
                int indexToAdd = expressionsList.size();
                this.target.getLanguages().add((Object)newLanguage);
                this.target.getBodies().add((Object)DEFAULT_BODY_STRING);
                this.refresh(indexToAdd);
            }
        } else {
            throw new OperationCanceledException();
        }
    }

    private void removeButtonCallback() {
        List<ExpressionList.Expression> selectedExpressions = this.selectionToList(this.tableViewer.getSelection());
        for (ExpressionList.Expression expression : selectedExpressions) {
            int expressionIndex = this.expressionIndex(expression);
            this.target.getLanguages().remove(expressionIndex);
            this.target.getBodies().remove(expressionIndex);
        }
        this.refresh(-1);
    }

    private void editButtonCallback() {
        List<ExpressionList.Expression> selectedExpressions = this.selectionToList(this.tableViewer.getSelection());
        if (!selectedExpressions.isEmpty()) {
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), EDIT_LANGUAGE_DIALOG_TITLE, EDIT_LANGUAGE_DIALOG_MESSAGE, this.currentExpression.getLanguage(), null);
            if (dialog.open() == 0) {
                String newLanguage = dialog.getValue();
                int expressionIndex = this.expressionIndex(this.currentExpression);
                this.target.getLanguages().set(expressionIndex, (Object)newLanguage);
                this.refresh(expressionIndex);
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    private List<ExpressionList.Expression> getExpressionsList() {
        ArrayList<ExpressionList.Expression> expressionsList = new ArrayList<ExpressionList.Expression>();
        EList languageList = this.target.getLanguages();
        EList bodyList = this.target.getBodies();
        int i = 0;
        while (i < languageList.size()) {
            ExpressionList.Expression e = new ExpressionList.Expression();
            e.setLanguage((String)languageList.get(i));
            if (bodyList != null && i < bodyList.size()) {
                e.setBody((String)bodyList.get(i));
            } else {
                e.setBody(DEFAULT_BODY_STRING);
                this.editingContextAdapter.performModelChange(() -> LanguageExpressionLifecycleManager.lambda$9((List)bodyList));
            }
            expressionsList.add(e);
            ++i;
        }
        return expressionsList;
    }

    private int expressionIndex(ExpressionList.Expression expression) {
        return this.target.getLanguages().indexOf((Object)expression.getLanguage());
    }

    private List<ExpressionList.Expression> selectionToList(ISelection selection) {
        ArrayList<ExpressionList.Expression> expressions = new ArrayList<ExpressionList.Expression>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedObject = objectArray[n2];
                if (selectedObject instanceof ExpressionList.Expression) {
                    ExpressionList.Expression selectedExpression = (ExpressionList.Expression)selectedObject;
                    expressions.add(selectedExpression);
                }
                ++n2;
            }
        }
        return expressions;
    }

    protected void removeListener(Button button, ButtonSelectionListener listener) {
        if (button != null && !button.isDisposed()) {
            button.removeSelectionListener((SelectionListener)listener);
        }
    }

    private static /* synthetic */ void lambda$9(List list) {
        list.add(DEFAULT_BODY_STRING);
    }

    protected static class ButtonSelectionListener
    implements SelectionListener {
        private EditingContextAdapter editingContextAdapter;
        private Runnable runnable;

        public ButtonSelectionListener(EditingContextAdapter editingContextAdapter, Runnable runnable) {
            this.editingContextAdapter = editingContextAdapter;
            this.runnable = runnable;
        }

        public void widgetSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.editingContextAdapter.performModelChange(this.runnable);
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

