/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowDeleteEvent
extends RowStructuralChangeEvent {
    public RowDeleteEvent(ILayer layer, int rowPosition) {
        this(layer, new Range(rowPosition, rowPosition + 1));
    }

    public RowDeleteEvent(ILayer layer, Range ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowDeleteEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        super(layer, rowPositionRanges);
    }

    protected RowDeleteEvent(RowDeleteEvent event) {
        super(event);
    }

    @Override
    public RowDeleteEvent cloneEvent() {
        return new RowDeleteEvent(this);
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        return true;
    }

    public Collection<Integer> getDeletedRowIndexes() {
        HashSet<Integer> rowIndexes = new HashSet<Integer>();
        for (Range range : this.getRowPositionRanges()) {
            int i = range.start;
            while (i < range.end) {
                rowIndexes.add(this.getLayer().getRowIndexByPosition(i));
                ++i;
            }
        }
        return rowIndexes;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>(this.getRowPositionRanges().size());
        for (Range range : this.getRowPositionRanges()) {
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, range, new Range(range.start, range.start)));
        }
        return rowDiffs;
    }
}

