/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleBoundsProvider;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainter;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainterHelper;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.GraphicsUtils;
import org.eclipse.nebula.widgets.nattable.painter.layer.CompositeFreezeLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class FillHandleCompositeFreezeLayerPainter
extends CompositeFreezeLayerPainter
implements FillHandleBoundsProvider {
    protected Rectangle handleBounds;

    public FillHandleCompositeFreezeLayerPainter(CompositeFreezeLayer compositeFreezeLayer) {
        super(compositeFreezeLayer);
    }

    public FillHandleCompositeFreezeLayerPainter(CompositeLayer compositeLayer, CompositeFreezeLayer compositeFreezeLayer) {
        super(compositeLayer, compositeFreezeLayer);
    }

    public FillHandleCompositeFreezeLayerPainter(CompositeLayer compositeLayer, CompositeFreezeLayer compositeFreezeLayer, boolean inspectComposite) {
        super(compositeLayer, compositeFreezeLayer, inspectComposite);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.handleBounds = null;
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        if (this.handleBounds != null) {
            this.paintFillHandle(gc, configRegistry);
        }
    }

    @Override
    protected void processLayerPainterInformation(ILayerPainter painter) {
        Rectangle bounds;
        if (painter instanceof FillHandleLayerPainter && (bounds = ((FillHandleLayerPainter)painter).getSelectionHandleBounds()) != null) {
            this.handleBounds = bounds;
        }
    }

    protected void paintFillHandle(GC gc, IConfigRegistry configRegistry) {
        Color originalBackground = gc.getBackground();
        Color color = this.getHandleColor(configRegistry);
        BorderStyle borderStyle = this.getHandleBorderStyle(configRegistry);
        gc.setBackground(color);
        Rectangle handleInterior = GraphicsUtils.getInternalBounds(this.handleBounds, borderStyle);
        GraphicsUtils.fillRectangle(gc, handleInterior);
        GraphicsUtils.drawRectangle(gc, handleInterior, borderStyle);
        gc.setBackground(originalBackground);
    }

    protected Color getHandleColor(IConfigRegistry configRegistry) {
        return FillHandleLayerPainterHelper.getHandleColor(configRegistry);
    }

    protected BorderStyle getHandleBorderStyle(IConfigRegistry configRegistry) {
        return FillHandleLayerPainterHelper.getHandleBorderStyle(configRegistry);
    }

    @Override
    public Rectangle getSelectionHandleBounds() {
        return this.handleBounds;
    }
}

