/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.structure2document.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.model2doc.core.internal.logger.DefaultModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.logger.IModel2DocLogger;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatus;
import org.eclipse.papyrus.model2doc.core.status.GenerationStatusDialogHelper;
import org.eclipse.papyrus.model2doc.core.status.IGenerationStatus;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Document;
import org.eclipse.papyrus.model2doc.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.IStructure2DocumentGenerator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.Structure2DocumentRegistry;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GenerateDocumentFileHandler
extends AbstractHandler {
    private Document selectedDocument;
    private IStructure2DocumentGenerator generator;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IGenerationStatus status = this.generate((IModel2DocLogger)new DefaultModel2DocLogger(Activator.log));
        GenerationStatusDialogHelper.INSTANCE.openMessageDialog(status);
        return status;
    }

    protected IGenerationStatus generate(IModel2DocLogger logger) {
        Object result = this.generator.generate(this.selectedDocument, logger);
        GenerationStatus status = new GenerationStatus(0, "org.eclipse.papyrus.model2doc.emf.structure2document", "The file has been generated.");
        status.setResult(result);
        return status;
    }

    public final void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(this.computeEnable(evaluationContext));
    }

    protected boolean computeEnable(Object evaluationContext) {
        boolean enabled;
        this.selectedDocument = this.getSelectedDocument();
        boolean bl = enabled = this.selectedDocument != null;
        if (enabled) {
            this.generator = Structure2DocumentRegistry.INSTANCE.getGenerator(this.selectedDocument);
            enabled = this.generator.handles(this.selectedDocument);
        }
        if (enabled && evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            iEvaluationContext.addVariable("generatorMenuLabel", (Object)this.generator.getEditorLabel());
        } else {
            enabled = false;
            this.selectedDocument = null;
            this.generator = null;
            if (evaluationContext instanceof IEvaluationContext) {
                IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
                iEvaluationContext.addVariable("generatorMenuLabel", (Object)"noGenerator");
            }
        }
        return enabled;
    }

    private Document getSelectedDocument() {
        ISelection selection;
        ISelectionService ss;
        IWorkbenchWindow wW;
        Object firstSelectedElement = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wW = wb.getActiveWorkbenchWindow()) != null && (ss = wW.getSelectionService()) != null && (selection = ss.getSelection()) instanceof IStructuredSelection && !selection.isEmpty()) {
            firstSelectedElement = ((IStructuredSelection)selection).getFirstElement();
        }
        if (firstSelectedElement instanceof IAdaptable) {
            firstSelectedElement = ((IAdaptable)firstSelectedElement).getAdapter(EObject.class);
        }
        if (firstSelectedElement instanceof Document) {
            return (Document)firstSelectedElement;
        }
        return null;
    }
}

