/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.ui.widgets;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.aas.Endpoint;
import org.eclipse.papyrus.aas.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityElementAdapter
extends AdapterImpl {
    public void setTarget(Notifier newTarget) {
        if (newTarget == null || this.getTargetType().isInstance(newTarget)) {
            super.setTarget(newTarget);
            if (newTarget instanceof Property) {
                this.handleNewTarget();
            }
        }
    }

    void handleNewTarget() {
        Property newTarget = this.getTarget();
        if (newTarget.getEndPoint() != null) {
            this.adapt((Notifier)newTarget.getEndPoint());
        }
    }

    Class<? extends Property> getTargetType() {
        return Property.class;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget == this.getTarget()) {
            this.handleOldTarget();
        }
        super.unsetTarget(oldTarget);
    }

    void handleOldTarget() {
        Property oldTarget = this.getTarget();
        if (oldTarget.getEndPoint() != null) {
            this.unadapt((Notifier)oldTarget.getEndPoint());
        }
    }

    public Property getTarget() {
        return (Property)super.getTarget();
    }

    public void adapt(Notifier notifier) {
        if (!notifier.eAdapters().contains((Object)this)) {
            notifier.eAdapters().add((Object)this);
        }
    }

    public void unadapt(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (notification.getFeature() != UMLPackage.Literals.OPAQUE_EXPRESSION__BODY) break;
            }
            case 1: 
            case 2: {
                if (notification.isTouch()) break;
            }
            case 9: {
                Property target = this.getTarget();
                Object notifier = notification.getNotifier();
                Object feature = notification.getFeature();
                if (notifier == target) {
                    switch (notification.getFeatureID(Property.class)) {
                        case 10: {
                            Endpoint oldValue = (Endpoint)notification.getOldValue();
                            Endpoint newValue = (Endpoint)notification.getNewValue();
                            this.adaptChange((Notifier)oldValue, (Notifier)newValue);
                        }
                    }
                    this.handleOtherTargetNotification(notification);
                    break;
                }
                if (this.handleDetailNotification(notifier, feature, notification)) break;
                this.unadapt((Notifier)notifier);
            }
        }
    }

    final void adaptChange(Notifier oldNotifier, Notifier newNotifier) {
        if (oldNotifier != null) {
            this.unadapt(oldNotifier);
        }
        if (newNotifier != null) {
            this.adapt(newNotifier);
        }
    }

    void handleOtherTargetNotification(Notification notification) {
    }

    boolean handleDetailNotification(Object notifier, Object feature, Notification notification) {
        boolean result = false;
        if (notifier instanceof Endpoint && this.getTarget() != null && ((Endpoint)notifier).eContainer() == this.getTarget()) {
            Endpoint value;
            result = true;
            if (feature instanceof EAttribute && (value = (Endpoint)notifier) == this.getTarget().getEndPoint()) {
                this.handleLowerValueChanged(value, (EAttribute)feature, notification);
            }
        }
        return result;
    }

    protected void handleLowerValueReplaced(Endpoint oldLowerValue, ValueSpecification newLowerValue, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    protected void handleUpperValueReplaced(ValueSpecification oldUpperValue, ValueSpecification newUpperValue, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    protected void handleMultiplicityChanged(Notification notification) {
    }

    protected void handleLowerValueChanged(Endpoint lowerValue, EAttribute feature, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    public static class ForProperty
    extends MultiplicityElementAdapter {
        @Override
        Class<? extends Property> getTargetType() {
            return Property.class;
        }

        @Override
        public Property getTarget() {
            return super.getTarget();
        }

        @Override
        void handleNewTarget() {
            super.handleNewTarget();
            Property newTarget = this.getTarget();
            if (newTarget.getEndPoint() != null) {
                this.adapt((Notifier)newTarget.getEndPoint());
            }
        }

        @Override
        void handleOldTarget() {
            Property oldTarget = this.getTarget();
            if (oldTarget.getEndPoint() != null) {
                this.unadapt((Notifier)oldTarget.getEndPoint());
            }
            super.handleOldTarget();
        }

        @Override
        void handleOtherTargetNotification(Notification notification) {
            switch (notification.getFeatureID(Property.class)) {
                case 15: {
                    Type oldType = (Type)notification.getOldValue();
                    Type newType = (Type)notification.getNewValue();
                    this.adaptChange((Notifier)oldType, (Notifier)newType);
                    this.handleTypeReplaced(oldType, newType, notification);
                }
            }
        }

        @Override
        boolean handleDetailNotification(Object notifier, Object feature, Notification notification) {
            boolean result = false;
            if (notifier instanceof Type && feature instanceof EStructuralFeature && this.getTarget().getEndPoint() == notifier) {
                result = true;
                this.handleTypeChanged((Type)notifier, (EStructuralFeature)feature, notification);
            }
            return result || super.handleDetailNotification(notifier, feature, notification);
        }

        protected void handleTypeReplaced(Type oldType, Type newType, Notification notification) {
            this.handleTypeChanged(notification);
        }

        protected void handleTypeChanged(Notification notification) {
            this.handleMultiplicityChanged(notification);
        }

        protected void handleTypeChanged(Type type, EStructuralFeature feature, Notification notification) {
            this.handleTypeChanged(notification);
        }
    }
}

