/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xpand.incremental.trace.OutputFile;
import org.eclipse.xpand.incremental.trace.Trace;
import org.eclipse.xpand2.output.Outlet;

public class FileCleaner
extends AbstractWorkflowComponent {
    private String oldTraceModelSlot;
    private String newTraceModelSlot;
    private Map<String, Outlet> outlets = new HashMap<String, Outlet>();
    private Outlet defaultOutlet;

    public void setOldTraceModelSlot(String oldTraceModelSlot) {
        this.oldTraceModelSlot = oldTraceModelSlot;
    }

    public void setNewTraceModelSlot(String newTraceModelSlot) {
        this.newTraceModelSlot = newTraceModelSlot;
    }

    public void addOutlet(Outlet outlet) {
        if (outlet == null) {
            return;
        }
        if (outlet.getName() == null) {
            this.defaultOutlet = outlet;
        } else {
            this.outlets.put(outlet.getName(), outlet);
        }
    }

    public void checkConfiguration(Issues issues) {
        if (this.oldTraceModelSlot == null) {
            issues.addError("oldTraceModelSlot must be set.");
        }
        if (this.newTraceModelSlot == null) {
            issues.addError("newTraceModelSlot must be set.");
        }
        if (this.outlets.isEmpty() && this.defaultOutlet == null) {
            issues.addError("outlets must be given.");
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Trace oldTraceModel = (Trace)ctx.get(this.oldTraceModelSlot);
        if (oldTraceModel == null) {
            issues.addWarning((WorkflowComponent)this, "oldTraceModelSlot " + this.oldTraceModelSlot + " is empty. Not cleaning any files.");
            return;
        }
        Trace newTraceModel = (Trace)ctx.get(this.newTraceModelSlot);
        if (newTraceModel == null) {
            issues.addWarning((WorkflowComponent)this, "newTraceModelSlot " + this.newTraceModelSlot + " is empty. Not cleaning any files.");
            return;
        }
        ArrayList<OutputFile> toDelete = new ArrayList<OutputFile>((Collection<OutputFile>)oldTraceModel.getOutputFiles());
        for (OutputFile oldFile : oldTraceModel.getOutputFiles()) {
            for (OutputFile newFile : newTraceModel.getOutputFiles()) {
                if (!this.isSameFile(oldFile, newFile)) continue;
                toDelete.remove(oldFile);
            }
        }
        int count = 0;
        for (OutputFile f : toDelete) {
            Outlet o = f.getOutlet() == null ? this.defaultOutlet : this.outlets.get(f.getOutlet());
            File deleteMe = new File(String.valueOf(o.getPath()) + File.separator + f.getFileName());
            if (!deleteMe.delete()) {
                issues.addWarning((WorkflowComponent)this, "Could not delete file " + deleteMe.getAbsolutePath());
                continue;
            }
            ++count;
        }
        if (count > 0) {
            issues.addInfo((WorkflowComponent)this, "Deleted " + count + " files.");
        }
    }

    private boolean isSameFile(OutputFile oldFile, OutputFile newFile) {
        return oldFile.getFileName().equals(newFile.getFileName()) && (oldFile.getOutlet() == null ? newFile.getOutlet() == null : oldFile.getOutlet().equals(newFile.getOutlet()));
    }
}

