/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.core.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;

public class StringUtil {
    private static String delims = " !:;{}(),.?'\"\\\t\n\r";
    private static final String PROTOCOL_DELIMITER = "://";
    private static final int PROTOCOL_DELIMITER_LENGTH = "://".length();
    private static final String URL_ENCODING = "UTF-8";
    private static final String ENCODED_PERCENT = "%25";
    static /* synthetic */ Class class$0;

    private StringUtil() {
    }

    private static String replaceFrom(String string, String source, String dest, boolean caseSensitive, int[] from) {
        if (source.compareTo("") == 0) {
            return string;
        }
        int stringLength = string.length();
        int sourceLength = source.length();
        int destLength = dest.length();
        while (from[0] + sourceLength <= stringLength) {
            int compareResult = caseSensitive ? string.substring(from[0], from[0] + sourceLength).compareTo(source) : string.substring(from[0], from[0] + sourceLength).compareToIgnoreCase(source);
            if (compareResult == 0) {
                int fromIndex = from[0];
                from[0] = from[0] + destLength;
                return String.valueOf(string.substring(0, fromIndex)) + dest + string.substring(fromIndex + sourceLength, stringLength);
            }
            from[0] = from[0] + 1;
        }
        return string;
    }

    private static String replaceFrom(String string, String source, String dest, boolean caseSensitive, int from) {
        int[] fromArray = new int[]{from};
        return StringUtil.replaceFrom(string, source, dest, caseSensitive, fromArray);
    }

    public static String replace(String string, String source, String dest, boolean caseSensitive) {
        return StringUtil.replaceFrom(string, source, dest, caseSensitive, 0);
    }

    private static String replaceAll(String string, String source, String dest, boolean caseSensitive, int from) {
        int[] fromArray = new int[]{from};
        String newString = StringUtil.replaceFrom(string, source, dest, caseSensitive, fromArray);
        from = fromArray[0];
        if (newString.compareTo(string) == 0) {
            return newString;
        }
        return StringUtil.replaceAll(newString, source, dest, caseSensitive, from);
    }

    public static String replaceAll(String string, String source, String dest, boolean caseSensitive) {
        return StringUtil.replaceAll(string, source, dest, caseSensitive, 0);
    }

    private static String replaceWholeWordsFrom(String string, String pattern, String dest, boolean caseSensitive, int[] fromArray) {
        int index;
        boolean frontOK = false;
        boolean backOK = false;
        int n = index = caseSensitive ? string.indexOf(pattern, fromArray[0]) : string.toUpperCase().indexOf(pattern.toUpperCase(), fromArray[0]);
        if (index == 0) {
            frontOK = true;
        } else if (index > 0 && delims.indexOf(string.charAt(index - 1)) >= 0) {
            frontOK = true;
        }
        if (frontOK) {
            if (index + pattern.length() >= string.length()) {
                backOK = true;
            } else if (delims.indexOf(string.charAt(index + pattern.length())) >= 0) {
                backOK = true;
            }
            if (backOK) {
                fromArray[0] = index - 1 < 0 ? 0 : index + dest.length();
                return String.valueOf(string.substring(0, index - 1 < 0 ? 0 : index)) + dest + (index + pattern.length() > string.length() ? "" : string.substring(index + pattern.length(), string.length()));
            }
        }
        if (index >= 0 && index + 1 < string.length()) {
            fromArray[0] = index + 1;
            return StringUtil.replaceWholeWordsFrom(string, pattern, dest, caseSensitive, fromArray);
        }
        return string;
    }

    public static String replaceWholeWords(String string, String source, String dest, boolean caseSensitive) {
        int[] fromArray = new int[1];
        return StringUtil.replaceWholeWordsFrom(string, source, dest, caseSensitive, fromArray);
    }

    public static String replaceAllWholeWords(String string, String source, String dest, boolean caseSensitive) {
        int[] fromArray = new int[1];
        String oldResult = null;
        String result = StringUtil.replaceWholeWordsFrom(string, source, dest, caseSensitive, fromArray);
        while (oldResult == null || !result.equals(oldResult)) {
            oldResult = result;
            result = StringUtil.replaceWholeWordsFrom(oldResult, source, dest, caseSensitive, fromArray);
        }
        return result;
    }

    public static boolean doesWordExist(String string, String source, boolean caseSensitive) {
        StringTokenizer st = new StringTokenizer(string);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((!caseSensitive || token.compareTo(source) != 0) && (caseSensitive || token.toUpperCase().compareTo(source.toUpperCase()) != 0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidPositiveInteger(String string) {
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) < '0' || string.charAt(i) > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String encodeURL(String url) {
        int protocolIndex = url.indexOf(PROTOCOL_DELIMITER);
        if (protocolIndex > 0) {
            String start = url.substring(0, protocolIndex + PROTOCOL_DELIMITER_LENGTH);
            int slashIndex = url.indexOf(47, protocolIndex + PROTOCOL_DELIMITER_LENGTH);
            if (slashIndex == -1) {
                slashIndex = url.length();
            }
            String domain = url.substring(protocolIndex + PROTOCOL_DELIMITER_LENGTH, slashIndex);
            String end = url.substring(slashIndex, url.length());
            end = StringUtil.encodePercentage(end);
            end = StringUtil.encode(end);
            return String.valueOf(start) + domain + end;
        }
        return url;
    }

    private static String encodePercentage(String string) {
        int index = string.indexOf(37);
        while (index != -1) {
            int length = string.length();
            if (length > index + 2) {
                if (!StringUtil.isOKForHex(string.charAt(index + 1)) || !StringUtil.isOKForHex(string.charAt(index + 2))) {
                    string = StringUtil.replace(string, index, ENCODED_PERCENT);
                }
            } else {
                string = StringUtil.replace(string, index, ENCODED_PERCENT);
            }
            index = string.indexOf(37, index + 1);
        }
        return string;
    }

    private static boolean isOKForHex(char aChar) {
        if (aChar >= '0' && aChar <= '9') {
            return true;
        }
        if (aChar >= 'a' && aChar <= 'f') {
            return true;
        }
        return aChar >= 'A' && aChar <= 'F';
    }

    private static String replace(String original, int index, String newPart) {
        return String.valueOf(original.substring(0, index)) + newPart + original.substring(index + 1);
    }

    private static int findUnEncodeableCharacter(String string, int start) {
        if (start >= string.length()) {
            return -1;
        }
        int[] indices = new int[]{string.indexOf(37, start), string.indexOf(47, start), string.indexOf(38, start), string.indexOf(61, start), string.indexOf(43, start), string.indexOf(63, start)};
        int index = -1;
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != -1 && indices[i] < index || index == -1) {
                index = indices[i];
            }
            ++i;
        }
        return index;
    }

    private static String encode(String string) {
        int beginIndex = StringUtil.findUnEncodeableCharacter(string, 0);
        if (beginIndex == -1) {
            beginIndex = 0;
        }
        while (beginIndex < string.length()) {
            int endIndex = StringUtil.findUnEncodeableCharacter(string, beginIndex + 1);
            if (endIndex == -1) {
                endIndex = string.length();
            }
            String begin = string.substring(0, beginIndex + 1);
            String middle = string.substring(beginIndex + 1, endIndex);
            String end = string.substring(endIndex);
            try {
                middle = URLEncoder.encode(middle, URL_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                Log.error(CommonCorePlugin.getDefault(), 8, "UTF-8 unsupported.");
                CommonCorePlugin commonCorePlugin = CommonCorePlugin.getDefault();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.gmf.runtime.common.core.util.StringUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.catching(commonCorePlugin, CommonCoreDebugOptions.EXCEPTIONS_CATCHING, clazz, "encode", e);
            }
            beginIndex = begin.length() + middle.length();
            string = String.valueOf(begin) + middle + end;
        }
        return string;
    }
}

