/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.sheet;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.graphdef.editor.sheet.ChangeTracker;

public final class AttachAdapter
extends AdapterImpl {
    private final Adapter[] myAdapters;
    private final EReference myRef;
    private final ChangeTracker myTracker;

    public AttachAdapter(EReference reference, Adapter ... attachAdapters) {
        this(reference, (ChangeTracker)null, attachAdapters);
    }

    public AttachAdapter(EReference reference, ChangeTracker tracker, Adapter ... attachAdapters) {
        assert (attachAdapters != null);
        assert (!Arrays.asList(attachAdapters).contains(null));
        assert (reference != null);
        this.myAdapters = attachAdapters;
        this.myRef = reference;
        this.myTracker = tracker;
    }

    public void setTarget(Notifier newTarget) {
        EObject eTarget;
        if (newTarget instanceof EObject && this.checkTarget(eTarget = (EObject)newTarget) && eTarget.eIsSet((EStructuralFeature)this.myRef)) {
            Object value = eTarget.eGet((EStructuralFeature)this.myRef, false);
            if (this.myRef.isMany() && value instanceof List) {
                for (Object o : (List)value) {
                    if (!(o instanceof EObject)) continue;
                    this.attachTo((EObject)o);
                }
            } else if (value instanceof EObject) {
                this.attachTo((EObject)value);
            }
        }
        super.setTarget(newTarget);
    }

    public void unsetTarget(Notifier oldTarget) {
        EObject eTarget;
        if (oldTarget instanceof EObject && this.checkTarget(eTarget = (EObject)oldTarget) && eTarget.eIsSet((EStructuralFeature)this.myRef)) {
            Object value = eTarget.eGet((EStructuralFeature)this.myRef, false);
            if (this.myRef.isMany() && value instanceof List) {
                for (Object o : (List)value) {
                    if (!(o instanceof EObject)) continue;
                    this.detachFrom((EObject)o);
                }
            } else if (value instanceof EObject) {
                this.detachFrom((EObject)value);
            }
        }
        super.unsetTarget(oldTarget);
    }

    public void notifyChanged(Notification msg) {
        if (msg.isTouch()) {
            return;
        }
        if (!this.myRef.equals(msg.getFeature())) {
            return;
        }
        switch (msg.getEventType()) {
            case 3: {
                if (msg.getNewValue() instanceof EObject) {
                    this.attachTo((EObject)msg.getNewValue());
                    break;
                }
                System.out.println("AttachAdapter.notifyChanged() - EReference.add(nonEObject)!!!");
                break;
            }
            case 5: {
                if (!(msg.getNewValue() instanceof Collection)) break;
                for (Object o : (Collection)msg.getNewValue()) {
                    if (!(o instanceof EObject)) continue;
                    this.attachTo((EObject)o);
                }
                break;
            }
            case 4: {
                if (!(msg.getOldValue() instanceof EObject)) break;
                this.detachFrom((EObject)msg.getOldValue());
                break;
            }
            case 6: {
                if (msg.getOldValue() instanceof Collection) {
                    for (Object o : (Collection)msg.getOldValue()) {
                        if (!(o instanceof EObject)) continue;
                        this.detachFrom((EObject)o);
                    }
                }
            }
            case 1: {
                if (msg.getOldValue() instanceof EObject) {
                    this.detachFrom((EObject)msg.getOldValue());
                }
                if (!(msg.getNewValue() instanceof EObject)) break;
                this.attachTo((EObject)msg.getNewValue());
                break;
            }
            case 2: {
                if (!(msg.getOldValue() instanceof EObject)) break;
                this.detachFrom((EObject)msg.getOldValue());
            }
        }
        if (this.myTracker != null) {
            this.myTracker.modelChanged(msg);
        }
    }

    private void attachTo(EObject obj) {
        int i = 0;
        while (i < this.myAdapters.length) {
            obj.eAdapters().add((Object)this.myAdapters[i]);
            ++i;
        }
    }

    private void detachFrom(EObject obj) {
        int i = this.myAdapters.length - 1;
        while (i >= 0) {
            obj.eAdapters().remove((Object)this.myAdapters[i]);
            --i;
        }
    }

    private boolean checkTarget(EObject eTarget) {
        return this.myRef.getEContainingClass().isSuperTypeOf(eTarget.eClass());
    }
}

