/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.graphdef.editor.edit.policies.GMFGraphBaseItemSemanticEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class ChildAccessReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ChildAccessReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ChildAccess)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof FigureDescriptor) || !(this.newEnd instanceof FigureDescriptor)) {
            return false;
        }
        Figure target = this.getLink().getFigure();
        return GMFGraphBaseItemSemanticEditPolicy.LinkConstraints.canExistChildAccess_4002(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Figure) || !(this.newEnd instanceof Figure)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof FigureDescriptor)) {
            return false;
        }
        FigureDescriptor source = (FigureDescriptor)this.getLink().eContainer();
        return GMFGraphBaseItemSemanticEditPolicy.LinkConstraints.canExistChildAccess_4002(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getAccessors().remove((Object)this.getLink());
        this.getNewSource().getAccessors().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setFigure(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ChildAccess getLink() {
        return (ChildAccess)this.getElementToEdit();
    }

    protected FigureDescriptor getOldSource() {
        return (FigureDescriptor)this.oldEnd;
    }

    protected FigureDescriptor getNewSource() {
        return (FigureDescriptor)this.newEnd;
    }

    protected Figure getOldTarget() {
        return (Figure)this.oldEnd;
    }

    protected Figure getNewTarget() {
        return (Figure)this.newEnd;
    }
}

