/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.genmodel.ui.jdtutils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenEnum;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelSwitch;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.search.genmodel.ui.Activator;
import org.eclipse.emf.search.genmodel.ui.l10n.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.PartInitException;

public class GenBaseJDTUtils {
    private static GenBaseJDTUtils instance;
    private GenClassSwitchUtil genClassSwitch = new GenClassSwitchUtil();

    public static GenBaseJDTUtils getInstance() {
        return instance == null ? (instance = new GenBaseJDTUtils()) : instance;
    }

    public void openITypeInJavaEditor(IType type) {
        try {
            JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
        }
        catch (PartInitException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.genmodel.ui", 0, Messages.getString("GenBaseJDTUtils.OpenITypeInJavaEditorError"), (Throwable)e));
        }
        catch (JavaModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.genmodel.ui", 0, Messages.getString("GenBaseJDTUtils.OpenITypeInJavaEditorError"), (Throwable)e));
            e.printStackTrace();
        }
    }

    public IType resolveGenBaseType(GenBase genBase) {
        IProject project = this.resolveModelProject(genBase);
        if (project instanceof IProject && this.isAnAccessibleJavaProject(project)) {
            return this.resolveGenBaseType(JavaCore.create((IProject)project), this.computeGeneratedJavaTypeFullyQualifiedName(genBase));
        }
        return null;
    }

    private String computeGeneratedJavaTypeFullyQualifiedName(GenBase genBase) {
        this.genClassSwitch.doSwitch((EObject)genBase);
        return this.genClassSwitch.getFullyQualifiedName();
    }

    private IType resolveGenBaseType(IJavaProject javaProject, String fullyQualifiedName) {
        try {
            return javaProject.findType(fullyQualifiedName);
        }
        catch (JavaModelException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.genmodel.ui", 0, Messages.getString("GenBaseJDTUtils.ResolveGenBaseTypeError"), (Throwable)e));
            e.printStackTrace();
            return null;
        }
    }

    private boolean isAnAccessibleJavaProject(IProject project) {
        boolean status = false;
        try {
            status = project != null && project.getType() == 4 && project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.genmodel.ui", 0, Messages.getString("GenBaseJDTUtils.IsAnAccessibleJavaProjectError"), (Throwable)e));
            e.printStackTrace();
        }
        return status;
    }

    public IProject resolveModelProject(GenBase genBase) {
        Object o;
        Object firstResource;
        ResourceSet resourceSet;
        if (genBase.eResource() != null && (resourceSet = genBase.eResource().getResourceSet()) != null && !resourceSet.getResources().isEmpty() && (firstResource = resourceSet.getResources().get(0)) instanceof Resource && !((Resource)firstResource).getContents().isEmpty() && (o = ((Resource)firstResource).getContents().get(0)) instanceof GenModel) {
            return this.resolveModelProject((GenModel)o);
        }
        return null;
    }

    public IProject resolveModelProject(GenModel genModel) {
        IResource p = ResourcesPlugin.getWorkspace().getRoot().findMember(genModel.getModelProjectDirectory());
        return p instanceof IProject ? (IProject)p : null;
    }

    public IProject resolveModelProject(String platformProjectName) {
        IResource p = ResourcesPlugin.getWorkspace().getRoot().findMember(platformProjectName, true);
        return p instanceof IProject ? (IProject)p : null;
    }

    public String computeModelProjectDirectory(GenModel genModel) {
        return genModel.getModelProjectDirectory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GenClassSwitchUtil
    extends GenModelSwitch<GenBase> {
        private String fullyQualifiedName = "";

        public GenBase caseGenClass(GenClass object) {
            this.fullyQualifiedName = object.isInterface() ? object.getQualifiedInterfaceName() : object.getQualifiedClassName();
            return (GenBase)super.caseGenClass(object);
        }

        public GenBase caseGenEnum(GenEnum object) {
            this.fullyQualifiedName = object.getQualifiedName();
            return (GenBase)super.caseGenEnum(object);
        }

        public GenBase caseGenPackage(GenPackage object) {
            this.fullyQualifiedName = object.getQualifiedPackageClassName();
            return (GenBase)super.caseGenPackage(object);
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public GenBase doSwitch(EObject theEObject) {
            this.fullyQualifiedName = "";
            return (GenBase)super.doSwitch(theEObject);
        }

        protected GenBase doSwitch(EClass theEClass, EObject theEObject) {
            this.fullyQualifiedName = "";
            return (GenBase)super.doSwitch(theEClass, theEObject);
        }

        protected GenBase doSwitch(int classifierID, EObject theEObject) {
            this.fullyQualifiedName = "";
            return (GenBase)super.doSwitch(classifierID, theEObject);
        }
    }
}

