/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.examples.ecore.grep;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.scope.IModelSearchScope;
import org.eclipse.emf.search.ecore.common.utils.file.EcoreModelSearchDirectoryScopeFactory;
import org.eclipse.emf.search.ecore.common.utils.http.EcoreModelSearchHttpScopeFactory;
import org.eclipse.emf.search.ecore.helper.builder.EcoreTextualModelSearchQueryBuilderHelper;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionEnum;
import org.eclipse.emf.search.ecore.results.EcoreModelSearchResultEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreGrep {
    private static final String PATTERN_OPT_ID = "pattern";
    private static final String REGEX_PATTERN_OPT = "REGEX";
    private static final String CASE_PATTERN_OPT = "CASE";
    private static final String NORMAL_PATTERN_OPT = "NORMAL";
    private static final String DIR_OPT_ID = "dir";
    private static final String PARTICIPANT_OPT_ID = "participants";
    private static final String EXPR_OPT_ID = "expr";
    public static final EcoreGrep INSTANCE = new EcoreGrep();

    private EcoreGrep() {
    }

    private ModelSearchQueryTextualExpressionEnum computeQueryExpressionKind(String pattern) {
        if (REGEX_PATTERN_OPT.equals(pattern)) {
            return ModelSearchQueryTextualExpressionEnum.REGULAR_EXPRESSION;
        }
        if (CASE_PATTERN_OPT.equals(pattern)) {
            return ModelSearchQueryTextualExpressionEnum.CASE_SENSITIVE;
        }
        if (NORMAL_PATTERN_OPT.equals(pattern)) {
            return ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT;
        }
        return ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT;
    }

    public static void main(String[] args) {
        INSTANCE.runQuery(args);
    }

    private void runQueryOverHttp(String[] args) {
        this.runTextualGlobalRegexModelSearchRuntimeQueryOverHttp("*", Arrays.asList(EcorePackage.Literals.ECLASS), ModelSearchQueryTextualExpressionEnum.NORMAL_TEXT, Arrays.asList(args));
    }

    private void runQuery(String[] args) {
        GnuParser p = new GnuParser();
        Options options = this.initOptions();
        try {
            CommandLine cl = p.parse(options, args, true);
            ModelSearchQueryTextualExpressionEnum pattern = this.computeQueryExpressionKind(cl.getOptionValue(PATTERN_OPT_ID));
            ArrayList<File> fLst = new ArrayList<File>();
            String[] stringArray = cl.getOptionValues(DIR_OPT_ID);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fName = stringArray[n2];
                fLst.add(new File(fName));
                ++n2;
            }
            String expr = cl.getOptionValue(EXPR_OPT_ID) == null ? NORMAL_PATTERN_OPT : cl.getOptionValue(EXPR_OPT_ID);
            ArrayList<EObject> cLst = new ArrayList<EObject>();
            if (!cl.hasOption(PARTICIPANT_OPT_ID)) {
                cLst.addAll((Collection<EObject>)EcorePackage.eINSTANCE.getEClassifiers());
            } else {
                String[] stringArray2 = cl.getOptionValues(PARTICIPANT_OPT_ID);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String cName = stringArray2[n4];
                    cLst.add((EObject)EcorePackage.eINSTANCE.getEClassifier(cName));
                    ++n4;
                }
            }
            this.runTextualGlobalRegexModelSearchRuntimeQuery(expr, cLst, pattern, fLst);
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp("EcoreGrep", options);
            return;
        }
    }

    private Options initOptions() {
        Option patternOpt = new Option(PATTERN_OPT_ID, true, "pattern kind for Ecore query among 'REGEX', 'NORMAL', 'CASE' (Regular Expresion, Normal *,? Compliant Pattern, Case Sensitive) ");
        patternOpt.addValue(REGEX_PATTERN_OPT);
        patternOpt.addValue(NORMAL_PATTERN_OPT);
        patternOpt.addValue(CASE_PATTERN_OPT);
        patternOpt.setArgs(1);
        Option exprOpt = new Option(EXPR_OPT_ID, true, "expression");
        exprOpt.setArgs(1);
        exprOpt.setRequired(true);
        Option dirOpt = new Option(DIR_OPT_ID, true, "directory list");
        dirOpt.setArgs(-2);
        dirOpt.setRequired(true);
        Option participantOpt = new Option(PARTICIPANT_OPT_ID, true, "meta-element participant list");
        participantOpt.setArgs(-2);
        Options options = new Options();
        options.addOption(dirOpt);
        options.addOption(exprOpt);
        options.addOption(patternOpt);
        options.addOption(participantOpt);
        return options;
    }

    public void runModelSearchRuntimeQuery(IModelSearchQuery query) {
        query.runWithoutNotifications();
        for (IModelResultEntry entry : query.getModelSearchResult().getResultsFlatenned()) {
            if (!(entry instanceof EcoreModelSearchResultEntry)) continue;
            EcoreModelSearchResultEntry resultEntry = (EcoreModelSearchResultEntry)entry;
            System.out.println("[" + ((Resource)resultEntry.getTarget()).getURI().toFileString() + "] " + resultEntry.getModelResultFullyQualifiedName2());
        }
    }

    public void runTextualGlobalRegexModelSearchRuntimeQuery(String pattern, List<EObject> participants, ModelSearchQueryTextualExpressionEnum textualExpression, List<File> dirList) {
        IModelSearchScope scope = EcoreModelSearchDirectoryScopeFactory.getInstance().createModelSearchFileSystemDirectoryScope(dirList.toArray(new File[0]));
        IModelSearchQuery query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredTextualModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
        switch (textualExpression) {
            case REGULAR_EXPRESSION: {
                query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredRegexModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
                break;
            }
            case CASE_SENSITIVE: {
                query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredCaseSensitiveModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
            }
        }
        this.runModelSearchRuntimeQuery(query);
    }

    public void runTextualGlobalRegexModelSearchRuntimeQueryOverHttp(String pattern, List<EObject> participants, ModelSearchQueryTextualExpressionEnum textualExpression, List<String> urlList) {
        IModelSearchScope scope = EcoreModelSearchHttpScopeFactory.getInstance().createModelSearchHttpScope(urlList.toArray(new String[0]));
        IModelSearchQuery query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredTextualModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
        switch (textualExpression) {
            case REGULAR_EXPRESSION: {
                query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredRegexModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
                break;
            }
            case CASE_SENSITIVE: {
                query = EcoreTextualModelSearchQueryBuilderHelper.getInstance().buildFilteredCaseSensitiveModelSearchQuery(pattern, participants, scope, "http://www.eclipse.org/emf/2002/Ecore");
            }
        }
        this.runModelSearchRuntimeQuery(query);
    }
}

