/*******************************************************************************
 * Copyright (c) 2008 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.ui.source;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.mint.internal.ui.MintUI;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;

public class CustomizeGeneratedMethodHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection selection = HandlerUtil.getCurrentSelectionChecked(event);
		if (selection instanceof IStructuredSelection) {
			run((IStructuredSelection) selection, HandlerUtil
					.getActiveShell(event));
		} else if (selection instanceof ITextSelection) {
			run((ITextSelection) selection, HandlerUtil
					.getActiveEditorChecked(event));
		}

		return null;
	}

	@SuppressWarnings("unchecked")
	private void run(IStructuredSelection selection, Shell shell) {
		IMethod[] methods = new IMethod[selection.size()];
		selection.toList().toArray(methods);
		run(methods, shell);
	}

	private void run(ITextSelection selection, IEditorPart targetPart) {
		IEditorInput editorInput = targetPart.getEditorInput();
		Shell shell = targetPart.getSite().getShell();
		IJavaElement je = JavaUI.getEditorInputJavaElement(editorInput);
		IJavaElement element;
		try {
			element = getElementAtOffset(je, selection);
		} catch (JavaModelException e) {
			IStatus status = new Status(IStatus.ERROR, MintUI.PLUGIN_ID, 0,
					Messages.CustomizeGeneratedMethodAction_ErrorFindElement, e);
			MintUI.getDefault().getLog().log(status);
			ErrorDialog.openError(shell,
					Messages.CustomizeGeneratedMethodAction_ActionError, null,
					status);
			return;
		}

		if (!(element instanceof IMethod)
				|| !GeneratedMethodPropertyTester
						.isCustomizableMethod((IMethod) element)) {
			MessageDialog.openInformation(shell,
					Messages.CustomizeGeneratedMethodAction_ActionError,
					Messages.CustomizeGeneratedMethodAction_ErrorNotApplicable);
			return;
		}

		IMethod[] methods = new IMethod[] { (IMethod) element };
		run(methods, shell);
	}

	private void run(IMethod[] methods, Shell shell) {
		try {
			final CustomizeGeneratedMethodOperation op = new CustomizeGeneratedMethodOperation(
					methods);
			IProgressService svc = MintUI.getDefault().getWorkbench()
					.getProgressService();
			svc.runInUI(svc, new IRunnableWithProgress() {
				public void run(IProgressMonitor monitor)
						throws InvocationTargetException, InterruptedException {
					try {
						JavaCore.run(op, monitor);
					} catch (CoreException e) {
						throw new InvocationTargetException(e);
					}
				}
			}, ResourcesPlugin.getWorkspace().getRoot());
		} catch (InvocationTargetException e) {
			String msg = Messages.CustomizeGeneratedMethodAction_ErrorPerformAction;
			IStatus status = new Status(IStatus.ERROR, MintUI.PLUGIN_ID, 0,
					msg, e);
			MintUI.getDefault().getLog().log(status);
			if (e.getCause() instanceof CoreException)
				status = ((CoreException) e.getCause()).getStatus();
			else
				msg = null;

			ErrorDialog.openError(shell,
					Messages.CustomizeGeneratedMethodAction_ActionError, msg,
					status);
		} catch (InterruptedException e) {
			// ignore
		}
	}

	private IJavaElement getElementAtOffset(IJavaElement input,
			ITextSelection selection) throws JavaModelException {
		IJavaElement ref = null;
		if (input instanceof ICompilationUnit) {
			ICompilationUnit cunit = (ICompilationUnit) input;
			cunit.reconcile(ICompilationUnit.NO_AST, false, null, null);
			ref = cunit.getElementAt(selection.getOffset());
			if (ref == null)
				ref = input;
		} else if (input instanceof IClassFile) {
			ref = ((IClassFile) input).getElementAt(selection.getOffset());
			if (ref == null)
				ref = input;
		}

		return ref;
	}
}
