/*******************************************************************************
 * Copyright (c) 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.examples.ext.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;
import org.eclipse.emf.mint.IItemJavaElementSource;

public class GenFeatureItemProvider extends JavaElementItemProviderAdapter
		implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays
			.asList(GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList();

	public GenFeatureItemProvider(
			ValidatorJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenFeature genFeature = (GenFeature) object;
		if (!isFullyResolved(genFeature))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genFeature.getGenModel();
		String modelDir = genModel.getModelDirectory();
		
		GenClass genClass = genFeature.getGenClass();
		String basePackage = genClass.getGenPackage().getInterfacePackageName();
		String validationPackage = basePackage == null ? "validation."
				: basePackage + ".validation.";
		String validator = validationPackage + genClass.getInterfaceName()
				+ "Validator";

		addMethod(modelDir, validator, "validate"
				+ genFeature.getAccessorName(), genFeature.getType(null),
				CAT_VALIDATOR, "Validate method declaration", "Validate Method",
				GenModelPackage.Literals.GEN_FEATURE__ECORE_FEATURE, true, list);

		return list;
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenFeature(GenFeature object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new ObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenFeature(GenFeature object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
