/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.cdo.client.CDOPersistable;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.OptimisticControlException;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.client.PausableChangeRecorder;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.CDOResourceFactoryImpl;
import org.eclipse.emf.cdo.client.impl.PausableChangeRecorderImpl;
import org.eclipse.emf.cdo.client.protocol.ClientCDOProtocolImpl;
import org.eclipse.emf.cdo.core.OIDEncoder;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.spring.ValidationException;
import org.eclipse.net4j.spring.impl.ServiceImpl;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.thread.DeadlockDetector;
import org.eclipse.net4j.util.thread.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManagerImpl
extends ServiceImpl
implements ResourceManager {
    private static final int CAPACITY_oidToObjectMap = 10007;
    private ResourceSet resourceSet;
    private Connector connector;
    private PackageManager packageManager;
    private transient Channel cachedChannel;
    private transient boolean requestingObjects = true;
    private transient Map ridToResourceMap = new HashMap();
    private transient Map pathToResourceMap = new HashMap();
    private transient Map oidToObjectMap = new HashMap(10007);
    private transient List<EObject> detachedObjects = new ArrayList<EObject>();
    private transient List<Long> deferredInvalidations = new ArrayList<Long>();
    private transient PausableChangeRecorder transaction;
    private transient Invalidator invalidator;
    private transient List<ResourceManager.InvalidationListener> invalidationListeners = new ArrayList<ResourceManager.InvalidationListener>();
    private Adapter resourceSetAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (!(msg.getNotifier() instanceof ResourceSet) || msg.getNotifier() != ResourceManagerImpl.this.resourceSet) {
                throw new ImplementationError("Not adapted to this ResourceSet " + ResourceManagerImpl.this.resourceSet);
            }
            switch (msg.getEventType()) {
                case 4: {
                    if (!(msg.getOldValue() instanceof CDOResource)) break;
                    CDOResource resource = (CDOResource)msg.getOldValue();
                    resource.eAdapters().remove((Object)ResourceManagerImpl.this.transaction);
                    ResourceManagerImpl.this.notifyRemovedResource(resource);
                    break;
                }
                case 6: {
                    Collection newResources = (Collection)msg.getNewValue();
                    Collection oldResources = (Collection)msg.getOldValue();
                    for (Object element : oldResources) {
                        if (!(element instanceof CDOResource) || newResources.contains(element)) continue;
                        CDOResource resource = (CDOResource)element;
                        resource.eAdapters().remove((Object)ResourceManagerImpl.this.transaction);
                        ResourceManagerImpl.this.notifyRemovedResource(resource);
                    }
                    break;
                }
            }
        }
    };

    @Override
    public PackageManager getPackageManager() {
        return this.packageManager;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.doSet("packageManager", packageManager);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.doSet("connector", connector);
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(ResourceSet resourceSet) {
        this.doSet("resourceSet", resourceSet);
        resourceSet.eAdapters().add((Object)this.resourceSetAdapter);
        this.transaction = new PausableChangeRecorderImpl();
        this.transaction.beginRecording(resourceSet);
        CDOResourceFactoryImpl factory = new CDOResourceFactoryImpl(this);
        Map protocols = resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap();
        protocols.put("cdo", factory);
        Map extensions = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap();
        extensions.put("cdo", factory);
    }

    @Override
    public PausableChangeRecorder getTransaction() {
        return this.transaction;
    }

    @Override
    public Resource createResource(URI uri) {
        return this.resourceSet.createResource(uri);
    }

    @Override
    public Resource getResource(URI uri, boolean loadOnDemand) {
        return this.resourceSet.getResource(uri, loadOnDemand);
    }

    @Override
    public void registerResource(CDOResource resource) {
        Integer rid = new Integer(resource.getRID());
        this.ridToResourceMap.put(rid, resource);
    }

    @Override
    public void registerResourcePath(CDOResource cdoResource, String path) {
        cdoResource.setPath(path);
        this.pathToResourceMap.put(path, cdoResource);
    }

    @Override
    public CDOResource getResource(int rid) {
        CDOResource resource = (CDOResource)this.ridToResourceMap.get(new Integer(rid));
        if (resource == null) {
            URI uri = CDOResourceFactoryImpl.formatURI(rid);
            resource = (CDOResource)this.resourceSet.getResource(uri, true);
        }
        return resource;
    }

    @Override
    public Set queryExtent(EClass context, boolean exactMatch, CDOResource resource) {
        ClassInfo classInfo = this.packageManager.getClassInfo(context);
        return ClientCDOProtocolImpl.requestQueryExtent(this.getChannel(), classInfo.getCID(), exactMatch, resource != null ? resource.getRID() : 0);
    }

    @Override
    public Set queryExtent(EClass context, boolean exactMatch) {
        return this.queryExtent(context, exactMatch, null);
    }

    @Override
    public Set queryExtent(EClass context, CDOResource resource) {
        return this.queryExtent(context, false, resource);
    }

    @Override
    public Set queryExtent(EClass context) {
        return this.queryExtent(context, false, null);
    }

    @Override
    public EList queryCrossReferences(EObject object, CDOResource resource) {
        if (object instanceof CDOPersistable) {
            long oid = ((CDOPersistable)object).cdoGetOID();
            return ClientCDOProtocolImpl.requestQueryXRefs(this.getChannel(), oid, resource != null ? resource.getRID() : 0);
        }
        return ECollections.EMPTY_ELIST;
    }

    @Override
    public EList queryCrossReferences(EObject object) {
        return this.queryCrossReferences(object, null);
    }

    @Override
    public Channel getChannel() {
        if (this.cachedChannel == null) {
            this.cachedChannel = this.connector.addChannel("cdo");
            ClientCDOProtocolImpl.setResourceManager(this.cachedChannel, this);
        }
        return this.cachedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRemovedResource(CDOResource resource) {
        Integer rid = new Integer(resource.getRID());
        if (this.isDebugEnabled()) {
            this.debug("Removing resource with rid " + rid);
        }
        Map map = this.ridToResourceMap;
        synchronized (map) {
            this.ridToResourceMap.remove(rid);
        }
    }

    @Override
    public boolean isRollbackOnly() {
        return !this.deferredInvalidations.isEmpty();
    }

    @Override
    public boolean hasDeferredInvalidation(EObject object) {
        return this.deferredInvalidations.contains(object);
    }

    @Override
    public void commit() {
        if (this.transaction == null) {
            throw new ImplementationError("No transaction!");
        }
        this.stopRequestingObjects();
        this.transaction.setRecording(true);
        ChangeDescription cd = this.transaction.endRecording();
        this.startRequestingObjects();
        cd.getObjectsToAttach().clear();
        cd.getObjectsToAttach().addAll(this.detachedObjects);
        this.detachedObjects.clear();
        boolean ok = ClientCDOProtocolImpl.requestCommit(this.getChannel(), cd, this.getPackageManager());
        this.processDeferredInvalidations();
        this.transaction.beginRecording(this.resourceSet);
        if (!ok) {
            throw new OptimisticControlException("Another CDO transaction has updated one of the objects to be saved. Your transaction has been rolled back.");
        }
    }

    @Override
    public EObject getObject(long oid) {
        EObject object = (EObject)this.oidToObjectMap.get(new Long(oid));
        if (object != null && ((InternalEObject)object).eProxyURI() == null) {
            return object;
        }
        return null;
    }

    @Override
    public EObject getProxyObject(long oid) {
        URI proxyUri;
        EObject object = (EObject)this.oidToObjectMap.get(new Long(oid));
        if (object != null && (proxyUri = ((InternalEObject)object).eProxyURI()) != null) {
            return object;
        }
        return null;
    }

    @Override
    public void registerObject(long oid, EObject object) {
        int rid = this.packageManager.getOidEncoder().getRID(oid);
        URI uri = CDOResourceFactoryImpl.formatURI(rid);
        this.resourceSet.getResource(uri, true);
        this.oidToObjectMap.put(new Long(oid), object);
        this.transaction.setLoading(true);
        this.transaction.addAdapter((Notifier)object);
        this.transaction.setLoading(false);
    }

    @Override
    public void requestObject(CDOPersistable cdoObject) {
        long oid = cdoObject.cdoGetOID();
        if (this.isDebugEnabled()) {
            this.debug("Demand loading object: " + this.packageManager.getOidEncoder().toString(oid));
        }
        ClientCDOProtocolImpl.requestLoad(this.getChannel(), oid);
    }

    @Override
    public void reRegisterObject(EObject object, long newId) {
        Long oldId = new Long(ResourceManagerImpl.getOID(object));
        if (this.isDebugEnabled()) {
            this.debug("Re-registering object " + this.packageManager.getOidEncoder().toString(oldId.longValue()) + " -> " + this.packageManager.getOidEncoder().toString(newId));
        }
        this.oidToObjectMap.remove(oldId);
        this.oidToObjectMap.put(new Long(newId), object);
    }

    @Override
    public void rollback() {
        if (this.transaction == null) {
            throw new ImplementationError("No transaction!");
        }
        ChangeDescription cd = this.transaction.endRecording();
        cd.apply();
        this.transaction.beginRecording(this.resourceSet);
    }

    @Override
    public boolean isRequestingObjects() {
        return this.requestingObjects;
    }

    @Override
    public void startRequestingObjects() {
        if (this.isDebugEnabled()) {
            this.debug("START requesting objects: " + Thread.currentThread());
        }
        this.requestingObjects = true;
        if (this.transaction != null) {
            this.transaction.setRecording(true);
        }
    }

    @Override
    public void stopRequestingObjects() {
        if (this.isDebugEnabled()) {
            this.debug("STOP requesting objects: " + Thread.currentThread());
        }
        this.requestingObjects = false;
        if (this.transaction != null) {
            this.transaction.setRecording(false);
        }
    }

    @Override
    public void handleRemovedResources(int[] rids) {
        EList resources = this.getResourceSet().getResources();
        Iterator it = resources.iterator();
        while (it.hasNext()) {
            CDOResource cdoResource;
            Resource resource = (Resource)it.next();
            if (!(resource instanceof CDOResource) || !this.isRIDContained((cdoResource = (CDOResource)resource).getRID(), rids)) continue;
            this.stopRequestingObjects();
            cdoResource.unload();
            it.remove();
            this.startRequestingObjects();
        }
    }

    private boolean isRIDContained(int rid, int[] rids) {
        int[] nArray = rids;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int contained = nArray[n];
            if (contained == rid) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void invalidateObjects(long[] oids) {
        if (this.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < oids.length) {
                long oid = oids[i];
                buffer.append(buffer.length() == 0 ? "[" : ", ");
                buffer.append(this.packageManager.getOidEncoder().toString(oid));
                ++i;
            }
            buffer.append("]");
            this.debug("Invalidating objects " + buffer);
        }
        this.invalidator.enqueue(oids);
    }

    @Override
    public void detachObject(EObject object) {
        this.detachedObjects.add(object);
    }

    @Override
    public URI createProxyURI(long oid) {
        OIDEncoder oidEncoder = this.packageManager.getOidEncoder();
        int rid = oidEncoder.getRID(oid);
        long oidFragment = oidEncoder.getOIDFragment(oid);
        StringBuffer buffer = new StringBuffer();
        buffer.append("cdo://");
        buffer.append(rid);
        buffer.append("#");
        buffer.append(oidFragment);
        if (this.isDebugEnabled()) {
            this.debug("Creating proxy URI " + buffer.toString());
        }
        return URI.createURI((String)buffer.toString());
    }

    public void stop() {
        if (this.cachedChannel != null) {
            try {
                this.cachedChannel.stop();
                this.cachedChannel = null;
            }
            catch (Exception ex) {
                this.error("Problem while stopping channel " + this.cachedChannel, ex);
            }
        }
    }

    protected void validate() throws ValidationException {
        super.validate();
        this.assertNotNull("packageManager");
        this.assertNotNull("connector");
        this.assertNotNull("resourceSet");
    }

    protected void activate() throws Exception {
        super.activate();
        this.invalidator = new Invalidator();
        this.invalidator.setDaemon(true);
        this.invalidator.startup();
    }

    protected void deactivate() throws Exception {
        this.invalidator.shutdown(200L);
        this.invalidator = null;
        this.cachedChannel = null;
        this.connector = null;
        this.deferredInvalidations = null;
        this.invalidationListeners = null;
        this.invalidator = null;
        this.oidToObjectMap = null;
        this.packageManager = null;
        this.pathToResourceMap = null;
        this.resourceSet = null;
        this.resourceSetAdapter = null;
        this.ridToResourceMap = null;
        this.transaction = null;
        super.deactivate();
    }

    @Override
    public EObject createEObject(EClass eClass, long oid, int oca, CDOResource resource) {
        EObject persistable = EcoreUtil.create((EClass)eClass);
        ResourceManagerImpl.initPersistable(persistable, resource, oid, oca);
        return persistable;
    }

    public static long getOID(EObject eObject) {
        return ((CDOPersistable)eObject).cdoGetOID();
    }

    public static int getOCA(EObject eObject) {
        return ((CDOPersistable)eObject).cdoGetOCA();
    }

    public static void initPersistable(EObject persistable, CDOResource resource, long oid, int oca) {
        CDOPersistable p = (CDOPersistable)persistable;
        p.cdoSetResource(resource);
        p.cdoSetOID(oid);
        p.cdoSetOCA(oca);
        PausableChangeRecorder transaction = resource.getResourceManager().getTransaction();
        transaction.addAdapter((Notifier)p);
    }

    public static void incOCA(EObject eObject) {
        int oca = ((CDOPersistable)eObject).cdoGetOCA();
        ((CDOPersistable)eObject).cdoSetOCA(oca + 1);
    }

    public static String getLabel(EObject eObject) {
        EClass eclass = eObject.eClass();
        String label = eclass.getName();
        try {
            EStructuralFeature nameFeature = eclass.getEStructuralFeature("name");
            if (nameFeature != null) {
                Object o = eObject.eGet(nameFeature);
                label = String.valueOf(label) + " " + (String)o;
            }
        }
        catch (Throwable throwable) {}
        try {
            label = String.valueOf(label) + " " + ResourceManagerImpl.getOID(eObject) + "v" + ResourceManagerImpl.getOCA(eObject);
        }
        catch (Throwable throwable) {}
        return label;
    }

    @Override
    public void addInvalidationListener(ResourceManager.InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public void removeInvalidationListener(ResourceManager.InvalidationListener listener) {
        this.invalidationListeners.remove(listener);
    }

    protected void processDeferredInvalidations() {
        long[] oids = new long[this.deferredInvalidations.size()];
        int i = 0;
        for (Long oid : this.deferredInvalidations) {
            oids[i++] = oid;
        }
        this.deferredInvalidations.clear();
        this.processInvalidations(oids);
    }

    protected synchronized void processInvalidations(long[] oids) {
        ArrayList<EObject> invalidated = new ArrayList<EObject>();
        ArrayList<EObject> deferred = new ArrayList<EObject>();
        int i = 0;
        while (i < oids.length) {
            long oid = oids[i];
            EObject object = this.getObject(oid);
            if (object == null) {
                if (this.isDebugEnabled()) {
                    this.debug("Processing invalidation " + this.packageManager.getOidEncoder().toString(oid) + " (IGNORED)");
                }
            } else if (this.transaction.isChanged(object)) {
                if (this.isDebugEnabled()) {
                    this.debug("Processing invalidation " + this.packageManager.getOidEncoder().toString(oid) + " (DEFERRED)");
                }
                deferred.add(object);
                this.deferredInvalidations.add(oid);
            } else {
                if (this.isDebugEnabled()) {
                    this.debug("Processing invalidation " + this.packageManager.getOidEncoder().toString(oid));
                }
                invalidated.add(object);
                URI uri = this.createProxyURI(oid);
                ((InternalEObject)object).eSetProxyURI(uri);
                ((CDOPersistable)object).cdoSetOCA(-1);
            }
            ++i;
        }
        this.notifyInvalidationListeners(invalidated, deferred);
    }

    protected void notifyInvalidationListeners(List<EObject> invalidated, List<EObject> deferred) {
        for (ResourceManager.InvalidationListener listener : this.invalidationListeners) {
            listener.notifyInvalidation(this, invalidated, deferred);
        }
    }

    private final class Invalidator
    extends Worker {
        private BlockingQueue<Entry> queue;

        public Invalidator() {
            super(String.valueOf(ResourceManagerImpl.this.getFullBeanName()) + ".Invalidator");
            this.queue = new LinkedBlockingQueue<Entry>();
        }

        public void enqueue(long[] oids) {
            Entry entry = new Entry();
            entry.entered = System.currentTimeMillis();
            entry.oids = oids;
            try {
                this.queue.put(entry);
            }
            catch (InterruptedException interruptedException) {}
        }

        protected long doWorkStep(int progress) {
            Entry entry;
            block7: {
                entry = this.queue.poll(50L, TimeUnit.MILLISECONDS);
                if (ResourceManagerImpl.this.isActive()) break block7;
                return -1L;
            }
            try {
                if (entry != null) {
                    while (System.currentTimeMillis() < entry.entered + 50L || !ResourceManagerImpl.this.isRequestingObjects()) {
                        DeadlockDetector.sleep((long)2L);
                    }
                    ResourceManagerImpl.this.processInvalidations(entry.oids);
                }
            }
            catch (InterruptedException interruptedException) {
                return -1L;
            }
            catch (NoClassDefFoundError ex) {
                if (!this.isRunning()) {
                    return -1L;
                }
                throw ex;
            }
            return 0L;
        }

        private class Entry {
            public long entered;
            public long[] oids;

            private Entry() {
            }
        }
    }
}

