/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.client.CDOResource;
import org.eclipse.emf.cdo.client.ResourceManager;
import org.eclipse.emf.cdo.client.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.client.impl.ResourceInfoImpl;
import org.eclipse.emf.cdo.client.protocol.ClientCDOProtocolImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.net4j.util.StringHelper;

public class CDOResourceFactoryImpl
implements Resource.Factory {
    private static final Logger logger = Logger.getLogger(CDOResourceFactoryImpl.class);
    protected ResourceManager resourceManager;

    public CDOResourceFactoryImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Resource createResource(URI uri) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating resource from URI " + uri));
        }
        if (!"cdo".equals(uri.scheme())) {
            return this.createResourceFromFile(uri.path().substring("/resource".length()));
        }
        int rid = CDOResourceFactoryImpl.parseRID(uri.authority());
        if (rid != -1) {
            return this.createResourceFromRID(rid);
        }
        return this.createResourceFromPath(uri.path());
    }

    private Resource createResourceFromFile(String fileName) {
        String path;
        Properties properties;
        try {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
            properties = new Properties();
            try {
                properties.load(file.getContents());
            }
            catch (CoreException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        catch (IOException ex) {
            logger.warn((Object)"Error while creating CDO resource", (Throwable)ex);
            return null;
        }
        String resourcePath = properties.getProperty("cdo.resource", "");
        if (resourcePath.length() != 0) {
            path = resourcePath;
        } else {
            String prefix = properties.getProperty("cdo.prefix", "");
            String replace = properties.getProperty("cdo.replace", "");
            if (fileName.startsWith(prefix)) {
                path = String.valueOf(replace) + StringHelper.removePrefix((String)fileName, (String)prefix);
            }
            path = StringHelper.removeSuffix((String)fileName, (String)".cdo");
        }
        return this.createResourceFromPath(path);
    }

    private CDOResource createResourceFromPath(String path) {
        int rid;
        boolean existing;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating resource with path " + path));
        }
        boolean bl = existing = (rid = ClientCDOProtocolImpl.requestResourcePath(this.resourceManager.getChannel(), path)) > 0;
        if (!existing) {
            rid = -rid;
        }
        return this.createResource(rid, path, existing);
    }

    private CDOResource createResourceFromRID(int rid) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating resource with RID " + rid));
        }
        return this.createResource(rid, null, true);
    }

    private CDOResource createResource(int rid, String path, boolean existing) {
        ResourceInfoImpl resourceInfo = new ResourceInfoImpl(path, rid, existing);
        CDOResourceImpl resource = new CDOResourceImpl(resourceInfo, this.resourceManager);
        this.resourceManager.registerResource(resource);
        resource.eAdapters().add((Object)this.resourceManager.getTransaction());
        return resource;
    }

    public static URI formatURI(String path) {
        return URI.createURI((String)("cdo://" + path));
    }

    public static URI formatURI(int rid) {
        return CDOResourceFactoryImpl.formatURI(String.valueOf(rid));
    }

    public static int parseRID(String path) {
        if (path == null || path.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(path);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

