/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.impl;

import org.eclipse.emf.cdo.client.AttributeConverter;
import org.eclipse.emf.cdo.client.AttributeInfo;
import org.eclipse.emf.cdo.client.ClassInfo;
import org.eclipse.emf.cdo.client.PackageManager;
import org.eclipse.emf.cdo.mapping.AttributeMapping;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;

public class AttributeInfoImpl
implements AttributeInfo {
    private ClassInfo classInfo;
    private transient EAttribute attribute;
    private transient int dataType;
    private transient AttributeMapping mapping;

    public AttributeInfoImpl(EAttribute attribute, AttributeMapping mapping, ClassInfo classInfo) {
        this.attribute = attribute;
        this.mapping = mapping;
        this.classInfo = classInfo;
        this.initDataType();
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.attribute.getName();
    }

    public EAttribute getEAttribute() {
        return this.attribute;
    }

    public AttributeMapping getMapping() {
        return this.mapping;
    }

    public int getDataType() {
        return this.dataType;
    }

    private void initDataType() {
        EDataType attributeType = this.attribute.getEAttributeType();
        PackageManager packageManager = this.getClassInfo().getPackageInfo().getPackageManager();
        AttributeConverter converter = packageManager.getAttributeConverter();
        this.dataType = converter.getCDODataType(attributeType);
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }
}

