/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import org.eclipse.emf.henshin.statespace.Model;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceException;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.commands.AbstractStateSpaceCommand;

public class CreateInitialStateCommand
extends AbstractStateSpaceCommand {
    private State state;
    private Model model;
    private int[] location;

    public CreateInitialStateCommand(Model model, StateSpaceManager manager) {
        super("create initial state", manager);
        this.model = model;
    }

    public boolean canExecute() {
        return this.model != null && this.getStateSpaceManager() != null;
    }

    @Override
    public void doRedo() throws StateSpaceException {
        this.state = this.getStateSpaceManager().createInitialState(this.model);
        this.state.setLocation(this.location);
    }

    @Override
    public void doUndo() throws StateSpaceException {
        this.getStateSpaceManager().removeState(this.state);
    }

    public void setLocation(int ... location) {
        this.location = location;
    }
}

