/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.actions.AbstractStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.commands.ResetStateSpaceCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ResetStateSpaceAction
extends AbstractStateSpaceAction {
    public void run(IAction action) {
        Shell shell = this.getExplorer().getSite().getShell();
        boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)"Reset State Space", (String)"All derived states will be deleted. Really continue?");
        if (confirmed) {
            StateSpaceManager manager = this.getExplorer().getStateSpaceManager();
            ResetStateSpaceCommand command = new ResetStateSpaceCommand(manager);
            try {
                this.getExplorer().executeCommand(command);
            }
            catch (Throwable t) {
                StateSpaceExplorerPlugin.getInstance().logError("Error reseting state space", t);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error reseting state space. See the error log for more information.");
            }
        }
    }
}

