/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.util.Map;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.actions.EditPropertiesPage;
import org.eclipse.emf.henshin.statespace.explorer.commands.ResetStateSpaceCommand;
import org.eclipse.emf.henshin.statespace.explorer.commands.SetPropertiesCommand;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceExplorer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class EditPropertiesWizard
extends Wizard {
    private StateSpaceExplorer explorer;
    private EditPropertiesPage propertiesPage;

    public EditPropertiesWizard(StateSpaceExplorer explorer) {
        this.explorer = explorer;
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle("Edit State Space Properties");
    }

    public void addPages() {
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        this.propertiesPage = new EditPropertiesPage(stateSpace);
        this.addPage((IWizardPage)this.propertiesPage);
    }

    public boolean performFinish() {
        if (this.propertiesPage.isDirty()) {
            StateSpaceManager manager = this.explorer.getStateSpaceManager();
            Map<String, String> props = this.propertiesPage.getResult();
            SetPropertiesCommand setProps = new SetPropertiesCommand(manager, props);
            setProps.setMaxStateDistance(this.propertiesPage.getNewMaxStateDistance());
            this.explorer.executeCommand(setProps);
            if (manager.getStateSpace().getTransitionCount() > 0 && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Reset", (String)"Changing the properties may affect the state space generation. Therefore we recommend to reset the state space now. Should the state space be reset?")) {
                this.explorer.getJobManager().stopAllJobs();
                this.explorer.executeCommand(new ResetStateSpaceCommand(manager));
            }
        }
        return true;
    }
}

