/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.diagram.edit.actions.NodeActionHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class NodeDeleteCommand
extends AbstractTransactionalCommand {
    private Node node;

    public NodeDeleteCommand(TransactionalEditingDomain domain, Node node) {
        super(domain, "Delete Node", null);
        this.node = node;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.node.getGraph() == null) {
            return CommandResult.newOKCommandResult();
        }
        if (NodeActionHelper.INSTANCE.getAction(this.node) == null) {
            this.node.getGraph().removeNode(this.node);
            return CommandResult.newWarningCommandResult((String)"Node seems to be illegal. Deleted anyway.", null);
        }
        NodeActionHelper.INSTANCE.setAction(this.node, new Action(ActionType.DELETE, new String[0]));
        Rule kernel = this.node.getGraph().getContainerRule();
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel);
        if (amalgamation != null) {
            for (Rule multi : amalgamation.getMultiRules()) {
                Node image = HenshinMappingUtil.getNodeImage((Node)this.node, (Graph)multi.getLhs(), (List)amalgamation.getLhsMappings());
                if (image == null) continue;
                image.getGraph().removeNode(image);
                HenshinMappingUtil.removeMapping((Node)this.node, (Node)image, (List)amalgamation.getLhsMappings());
            }
        }
        this.node.getGraph().removeNode(this.node);
        HenshinNACUtil.removeTrivialNACs((Rule)kernel);
        if (amalgamation != null) {
            AmalgamationEditHelper.cleanUpAmalagamation(amalgamation);
        }
        return CommandResult.newOKCommandResult();
    }
}

