/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.diagram.edit.actions.Action;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionHelper;
import org.eclipse.emf.henshin.diagram.edit.actions.ActionType;
import org.eclipse.emf.henshin.diagram.edit.helpers.AmalgamationEditHelper;
import org.eclipse.emf.henshin.model.AmalgamationUnit;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinNACUtil;

class ActionElementFinder {
    ActionElementFinder() {
    }

    static <E extends GraphElement> List<E> getRuleElementCandidates(Rule kernel, Action action, EReference containment) {
        ArrayList candidates = new ArrayList();
        AmalgamationUnit amalgamation = AmalgamationEditHelper.getAmalgamationFromKernelRule(kernel);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (action == null || !action.isAmalgamated()) {
            rules.add(kernel);
        }
        if ((action == null || action.isAmalgamated()) && amalgamation != null) {
            rules.addAll((Collection<Rule>)amalgamation.getMultiRules());
        }
        if (action == null || action.getType() == ActionType.DELETE || action.getType() == ActionType.PRESERVE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getLhs().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == ActionType.CREATE) {
            for (Rule rule : rules) {
                candidates.addAll((List)rule.getRhs().eGet((EStructuralFeature)containment));
            }
        }
        if (action == null || action.getType() == ActionType.FORBID) {
            for (NestedCondition nac : HenshinNACUtil.getAllNACs((Rule)kernel)) {
                candidates.addAll((List)nac.getConclusion().eGet((EStructuralFeature)containment));
            }
        }
        return candidates;
    }

    static <E extends GraphElement> E getActionElement(E element, ActionHelper<E, Rule> helper) {
        if (helper.getAction(element) != null) {
            return element;
        }
        EObject container = element.getGraph().eContainer();
        if (container instanceof Rule) {
            GraphElement originInKernel;
            AmalgamationUnit amalgamation;
            Rule rule = (Rule)container;
            Object origin = (GraphElement)HenshinMappingUtil.getOrigin(element, (List)rule.getMappings());
            if (origin == null) {
                origin = element;
            }
            if ((amalgamation = AmalgamationEditHelper.getAmalgamationFromMultiRule(rule)) != null && (originInKernel = AmalgamationEditHelper.getPreimageInKernelRule(origin, amalgamation)) != null) {
                return (E)originInKernel;
            }
            return (E)origin;
        }
        if (container instanceof NestedCondition) {
            EList mappings = ((NestedCondition)container).getMappings();
            return (E)((GraphElement)HenshinMappingUtil.getOrigin(element, (List)mappings));
        }
        throw new RuntimeException("Graph neither contained in a Rule nor in a NestedCondition");
    }
}

