/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.provider.filter.IFilterChangeListener;
import org.eclipse.emf.henshin.provider.filter.IFilterStore;

public class BaseFilterProvider {
    private Collection<IFilterChangeListener> listeners = new ArrayList<IFilterChangeListener>();
    protected Map<EClassifier, Boolean> filterMap = new HashMap<EClassifier, Boolean>();

    public BaseFilterProvider(IFilterStore store) {
        this.filterMap = store.getFilterPreferences();
        this.addFilterListener(store);
    }

    public void addFilterListener(IFilterChangeListener iFilterListener) {
        this.listeners.add(iFilterListener);
    }

    protected void setFiltered(boolean filtered, EClassifier c) {
        this.filterMap.put(c, filtered);
        for (IFilterChangeListener l : this.listeners) {
            l.filterChanged(c, filtered);
        }
    }

    public boolean isFiltered(EClassifier c) {
        Boolean value = this.filterMap.get(c);
        return value != null && value != false;
    }

    public Collection<? extends EStructuralFeature> filterChildFeatures(Collection<? extends EStructuralFeature> chidrenFeatures) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (EStructuralFeature eStructuralFeature : chidrenFeatures) {
            if (this.isFiltered(eStructuralFeature.getEType())) continue;
            result.add(eStructuralFeature);
        }
        return result;
    }
}

