/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider.descriptors;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.TransformationUnit;

public class ParameterMappingPropertyDescriptor
extends ItemPropertyDescriptor {
    ParameterItemDelegator pItemDelegator;

    public ParameterMappingPropertyDescriptor(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature) {
        super(adapterFactory, resourceLocator, displayName, description, feature, true, false, true, null, null, null);
        this.pItemDelegator = new ParameterItemDelegator(adapterFactory, resourceLocator);
        this.itemDelegator = this.pItemDelegator;
    }

    protected Collection<?> getComboBoxObjects(Object object) {
        if (object instanceof ParameterMapping) {
            ParameterMapping pmapping = (ParameterMapping)object;
            TransformationUnit owningUnit = (TransformationUnit)pmapping.eContainer();
            this.pItemDelegator.setCurrentTrafoUnit(owningUnit);
            HashSet result = new HashSet();
            result.addAll(owningUnit.getParameters());
            for (TransformationUnit tu : owningUnit.getSubUnits(false)) {
                result.addAll(tu.getParameters());
            }
            return result;
        }
        return super.getComboBoxObjects(object);
    }

    private class ParameterItemDelegator
    extends ItemPropertyDescriptor.ItemDelegator {
        TransformationUnit currentUnit;

        public ParameterItemDelegator(AdapterFactory adapterFactory, ResourceLocator resourceLocator) {
            super((ItemPropertyDescriptor)ParameterMappingPropertyDescriptor.this, adapterFactory, resourceLocator);
            this.currentUnit = null;
        }

        public String getText(Object object) {
            Parameter p = (Parameter)object;
            String text = this.normalize(p.getName());
            if (this.currentUnit == null || !this.currentUnit.equals(p.getUnit())) {
                String unitName = this.normalize(p.getUnit().getName());
                text = String.valueOf(text) + "  [" + unitName + "]";
            }
            return text;
        }

        private String normalize(String s) {
            return s == null || s.trim().isEmpty() ? "_" : s;
        }

        public void setCurrentTrafoUnit(TransformationUnit unit) {
            this.currentUnit = unit;
        }
    }
}

