/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.menuContributors;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.henshin.editor.commands.CopySubgraphCommand;
import org.eclipse.emf.henshin.editor.commands.MenuContributor;
import org.eclipse.emf.henshin.editor.commands.QuantUtil;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Not;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;
import org.eclipse.jface.action.IMenuManager;

public class CopySubgraphMenuContributor
extends MenuContributor {
    public static MenuContributor INSTANCE = new CopySubgraphMenuContributor();

    @Override
    protected void contributeActions(IMenuManager menuManager, List<?> selection) {
        if (selection.size() == 0) {
            return;
        }
        if (!QuantUtil.allInstancesOf(Node.class, selection.toArray())) {
            return;
        }
        Graph sourceGraph = ((Node)selection.get(0)).getGraph();
        if (HenshinRuleAnalysisUtil.isLHS((Graph)sourceGraph)) {
            CopySubgraphCommand cmd = new CopySubgraphCommand();
            cmd.setDomain(this.domain);
            cmd.setMappingOrigin(true);
            cmd.setSourceGraph(sourceGraph);
            cmd.setTargetGraph(sourceGraph.getContainerRule().getRhs());
            cmd.setMappings((Collection<Mapping>)sourceGraph.getContainerRule().getMappings());
            cmd.setNodes(selection);
            if (cmd.canExecute()) {
                menuManager.add(this.createAction("Copy to RHS", (Command)cmd));
            }
            this.walkNC(menuManager, sourceGraph.getFormula(), sourceGraph, selection);
        } else if (HenshinRuleAnalysisUtil.isRHS((Graph)sourceGraph)) {
            CopySubgraphCommand cmd = new CopySubgraphCommand();
            cmd.setDomain(this.domain);
            cmd.setMappingOrigin(false);
            cmd.setSourceGraph(sourceGraph);
            cmd.setTargetGraph(sourceGraph.getContainerRule().getLhs());
            cmd.setMappings((Collection<Mapping>)sourceGraph.getContainerRule().getMappings());
            cmd.setNodes(selection);
            if (cmd.canExecute()) {
                menuManager.add(this.createAction("Copy to LHS", (Command)cmd));
            }
        } else if (HenshinRuleAnalysisUtil.isConclusion((Graph)sourceGraph)) {
            this.walkNC(menuManager, sourceGraph.getFormula(), sourceGraph, selection);
        }
    }

    private void walkNC(IMenuManager menu, Formula formula, Graph sourceGraph, Collection<Node> selection) {
        if (formula == null) {
            return;
        }
        if (formula instanceof NestedCondition) {
            if (((NestedCondition)formula).getConclusion() == null) {
                return;
            }
            CopySubgraphCommand cmd = new CopySubgraphCommand();
            cmd.setDomain(this.domain);
            cmd.setMappingOrigin(true);
            cmd.setSourceGraph(sourceGraph);
            cmd.setTargetGraph(((NestedCondition)formula).getConclusion());
            cmd.setMappings((Collection<Mapping>)((NestedCondition)formula).getMappings());
            cmd.setNodes(selection);
            if (cmd.canExecute()) {
                menu.add(this.createAction("Copy to NC: " + ((NestedCondition)formula).getConclusion().getName(), (Command)cmd));
            }
        } else if (formula instanceof BinaryFormula) {
            this.walkNC(menu, ((BinaryFormula)formula).getLeft(), sourceGraph, selection);
            this.walkNC(menu, ((BinaryFormula)formula).getRight(), sourceGraph, selection);
        } else if (formula instanceof Not) {
            this.walkNC(menu, ((Not)formula).getChild(), sourceGraph, selection);
        }
    }
}

