/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.ChangeKind;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.ListChange;

public class ModelChange {
    private ChangeDescription change;
    private Collection<EObject> createdObjects = new ArrayList<EObject>();
    private Collection<EObject> deletedObjects = new ArrayList<EObject>();

    public ModelChange() {
        this.change = ChangeFactory.eINSTANCE.createChangeDescription();
        this.createdObjects = new ArrayList<EObject>();
        this.deletedObjects = new ArrayList<EObject>();
    }

    public void addCreatedObject(EObject eObject) {
        this.createdObjects.add(eObject);
    }

    public void addDeletedObject(EObject eObject) {
        this.deletedObjects.add(eObject);
    }

    private FeatureChange getFeatureChange(EObject eObject, EStructuralFeature feature) {
        if (this.change.getObjectChanges().get((Object)eObject) == null) {
            this.change.getObjectChanges().put((Object)eObject, (Object)new BasicEList());
        }
        EList featureChanges = (EList)this.change.getObjectChanges().get((Object)eObject);
        for (FeatureChange existingChange : featureChanges) {
            if (existingChange.getFeature() != feature) continue;
            return existingChange;
        }
        FeatureChange featureChange = ChangeFactory.eINSTANCE.createFeatureChange();
        featureChange.setFeature(feature);
        featureChanges.add((Object)featureChange);
        return featureChange;
    }

    private ListChange getListChangeByKind(FeatureChange featureChange, ChangeKind kind) {
        for (ListChange existingChange : featureChange.getListChanges()) {
            if (existingChange.getKind() != kind) continue;
            return existingChange;
        }
        ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
        listChange.setKind(kind);
        featureChange.getListChanges().add((Object)listChange);
        return listChange;
    }

    private boolean deletingChangeExists(FeatureChange featureChange, EObject value) {
        for (ListChange existingChange : featureChange.getListChanges()) {
            if (existingChange.getKind() != ChangeKind.REMOVE_LITERAL) continue;
            return existingChange.getReferenceValues().contains((Object)value);
        }
        return false;
    }

    public void addReferenceChange(EObject eObject, EReference reference, EObject value, boolean deletion) {
        FeatureChange featureChange = this.getFeatureChange(eObject, (EStructuralFeature)reference);
        if (reference.isMany()) {
            if (this.deletingChangeExists(featureChange, value)) {
                return;
            }
            ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
            listChange.setKind(deletion ? ChangeKind.REMOVE_LITERAL : ChangeKind.ADD_LITERAL);
            listChange.getReferenceValues().add((Object)value);
            if (deletion) {
                int idx = ((List)eObject.eGet((EStructuralFeature)reference)).indexOf(value);
                for (ListChange lChange : featureChange.getListChanges()) {
                    if (lChange.getKind() == ChangeKind.ADD_LITERAL) {
                        if (lChange.getIndex() >= idx) continue;
                        ++idx;
                        continue;
                    }
                    if (lChange.getKind() == ChangeKind.REMOVE_LITERAL) {
                        if (lChange.getIndex() >= idx) continue;
                        --idx;
                        continue;
                    }
                    if (lChange.getKind() != ChangeKind.MOVE_LITERAL) continue;
                    if (lChange.getIndex() < idx && lChange.getMoveToIndex() > idx) {
                        --idx;
                    }
                    if (lChange.getIndex() <= idx || lChange.getMoveToIndex() >= idx) continue;
                    ++idx;
                }
                listChange.setIndex(idx);
            }
            featureChange.getListChanges().add((Object)listChange);
        } else if (deletion) {
            featureChange.setReferenceValue(null);
        } else {
            featureChange.setReferenceValue(value);
        }
    }

    public void addAttributeChange(EObject eObject, EAttribute attribute, String value, boolean deletion) {
        FeatureChange featureChange = this.getFeatureChange(eObject, (EStructuralFeature)attribute);
        if (attribute.isMany()) {
            ListChange listChange = ChangeFactory.eINSTANCE.createListChange();
            listChange.setFeature((EStructuralFeature)attribute);
            listChange.setKind(deletion ? ChangeKind.REMOVE_LITERAL : ChangeKind.ADD_LITERAL);
            listChange.setIndex(((List)eObject.eGet((EStructuralFeature)attribute)).indexOf(value));
            if (!deletion) {
                listChange.getValues().add((Object)value);
            }
            featureChange.getListChanges().add((Object)listChange);
        } else {
            featureChange.setDataValue(value);
        }
    }

    public void applyChanges() {
        this.change.applyAndReverse();
    }

    public void undoChanges() {
        this.change.applyAndReverse();
    }

    public void redoChanges() {
        this.change.applyAndReverse();
    }

    public Collection<EObject> getCreatedObjects() {
        return this.createdObjects;
    }

    public Collection<EObject> getDeletedObjects() {
        return this.deletedObjects;
    }
}

