/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.metamodelevolution;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.henshin.interpreter.EmfEngine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.interfaces.InterpreterEngine;
import org.eclipse.emf.henshin.interpreter.util.ModelHelper;
import org.eclipse.emf.henshin.matching.EmfGraph;
import org.eclipse.emf.henshin.model.CountedUnit;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.model.TransformationUnit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.model.impl.HenshinPackageImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceFactory;

public class Evolution1 {
    private static final String BASE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/model/";
    private static final String MODEL_PETRI_META = "src/org/eclipse/emf/henshin/examples/metamodelevolution/model/petri.ecore";
    private static final String MODEL_PETRI_INSTANCE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/model/Net1.xmi";
    private static final String HENSHIN_PETRI_META = "src/org/eclipse/emf/henshin/examples/metamodelevolution/model/petriM.henshin";
    private static final String HENSHIN_PETRI_INSTANCE = "src/org/eclipse/emf/henshin/examples/metamodelevolution/model/petriI.henshin";
    ResourceSet resourceSet = new ResourceSetImpl();

    private void start() {
        this.initializeResourceFactories();
        EPackage petri = this.loadPetriEcoreModel();
        UnitApplication mm_unit1App = this.evolveMetaModel_ReplaceRefWithRefclass(petri, "Place", "Transition", "ArcPT");
        EClass srcType = (EClass)mm_unit1App.getParameterValue("objSource");
        EClass trgType = (EClass)mm_unit1App.getParameterValue("objTarget");
        EClass refclassType = (EClass)mm_unit1App.getParameterValue("objRefclass");
        EReference refType = (EReference)mm_unit1App.getParameterValue("objRef");
        EReference refSrcTrg = (EReference)mm_unit1App.getParameterValue("objRefSrcTrg");
        EReference refTrgSrc = (EReference)mm_unit1App.getParameterValue("objRefTrgSrc");
        this.migrateInstanceModel_ReplaceRefWithRefclass(petri, srcType, trgType, refType, refclassType, refSrcTrg, refTrgSrc);
        this.evolveMetaModel_DeleteOldReference(petri, refType);
    }

    private UnitApplication evolveMetaModel_ReplaceRefWithRefclass(EPackage petri, String srcNodeName, String trgNodeName, String refclassName) {
        TransformationSystem tsM = this.loadPetriTrafoSystemM();
        EmfGraph graphM = new EmfGraph();
        graphM.addRoot((EObject)petri);
        EmfEngine engineM = new EmfEngine(graphM);
        Rule mm_rule1 = tsM.findRuleByName("MM_CreateRefClass");
        UnitApplication mm_unit1App = new UnitApplication((InterpreterEngine)engineM, (TransformationUnit)mm_rule1);
        mm_unit1App.setParameterValue("srcName", (Object)srcNodeName);
        mm_unit1App.setParameterValue("trgName", (Object)trgNodeName);
        mm_unit1App.setParameterValue("refclassName", (Object)refclassName);
        boolean resultM = mm_unit1App.execute();
        if (!resultM) {
            System.out.println("\"MM_CreateRefClass\" not applied.");
            return null;
        }
        System.out.println("\"MM_CreateRefClass\" applied.");
        try {
            petri.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mm_unit1App;
    }

    private UnitApplication migrateInstanceModel_ReplaceRefWithRefclass(EPackage petri, EClass srcType, EClass trgType, EReference refType, EClass refclassType, EReference refSrcTrg, EReference refTrgSrc) {
        HenshinFactory hFac = HenshinFactoryImpl.eINSTANCE;
        TransformationSystem tsI = hFac.createTransformationSystem();
        tsI.getImports().add((Object)petri);
        Rule i_rule1 = hFac.createRule();
        tsI.getRules().add((Object)i_rule1);
        i_rule1.setActivated(true);
        i_rule1.setName("Migrate Instance Model");
        Graph lhs = i_rule1.getLhs();
        Graph rhs = i_rule1.getRhs();
        Node lhs_n_sC = hFac.createNode(lhs, srcType);
        Node lhs_n_tC = hFac.createNode(lhs, trgType);
        hFac.createEdge(lhs_n_sC, lhs_n_tC, refType);
        Node rhs_n_sC = hFac.createNode(rhs, srcType);
        Node rhs_n_tC = hFac.createNode(rhs, trgType);
        Node rhs_n_rC = hFac.createNode(rhs, refclassType);
        hFac.createEdge(rhs_n_sC, rhs_n_rC, refSrcTrg);
        hFac.createEdge(rhs_n_tC, rhs_n_rC, refTrgSrc);
        Mapping m1 = hFac.createMapping(lhs_n_sC, rhs_n_sC);
        i_rule1.getMappings().add((Object)m1);
        Mapping m2 = hFac.createMapping(lhs_n_tC, rhs_n_tC);
        i_rule1.getMappings().add((Object)m2);
        CountedUnit c_unit = hFac.createCountedUnit();
        c_unit.setCount(-1);
        tsI.getTransformationUnits().add((Object)c_unit);
        c_unit.setName("MigrationUnit");
        c_unit.setSubUnit((TransformationUnit)i_rule1);
        this.savePetriInstanceTrafoSystem(tsI);
        EObject net = this.loadPetriInstanceModel();
        EmfGraph graphI = new EmfGraph();
        graphI.addRoot(net);
        EmfEngine engineI = new EmfEngine(graphI);
        UnitApplication i_unit1App = new UnitApplication((InterpreterEngine)engineI, (TransformationUnit)c_unit);
        boolean resultI = i_unit1App.execute();
        if (!resultI) {
            System.out.println("Co-Evolution of instance model not successful.");
            return null;
        }
        System.out.println("Co-Evolution of instance model successful.");
        try {
            net.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return i_unit1App;
    }

    public UnitApplication evolveMetaModel_DeleteOldReference(EPackage petri, EReference refType) {
        TransformationSystem tsM = this.loadPetriTrafoSystemM();
        EmfGraph graphM = new EmfGraph();
        graphM.addRoot((EObject)petri);
        EmfEngine engineM = new EmfEngine(graphM);
        Rule mm_rule2 = tsM.findRuleByName("MM_DeleteOldRefs");
        UnitApplication mm_unit2App = new UnitApplication((InterpreterEngine)engineM, (TransformationUnit)mm_rule2);
        mm_unit2App.setParameterValue("objDelRef", (Object)refType);
        boolean resultM = mm_unit2App.execute();
        if (!resultM) {
            System.out.println("\"MM_DeleteOldRefs\" not applied.");
            return null;
        }
        System.out.println("\"MM_DeleteOldRefs\" applied.");
        try {
            petri.eResource().save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mm_unit2App;
    }

    private void savePetriInstanceTrafoSystem(TransformationSystem tsI) {
        URI iURI = URI.createFileURI((String)new File(HENSHIN_PETRI_INSTANCE).getAbsolutePath());
        Resource res = this.resourceSet.createResource(iURI, "henshin");
        res.getContents().add((Object)tsI);
        try {
            res.save(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private TransformationSystem loadPetriTrafoSystemM() {
        HenshinPackageImpl.init();
        TransformationSystem tsM = (TransformationSystem)ModelHelper.loadFile((String)HENSHIN_PETRI_META);
        return tsM;
    }

    private EPackage loadPetriEcoreModel() {
        URI modelUri = URI.createFileURI((String)new File(MODEL_PETRI_META).getAbsolutePath());
        Resource resourceModel = this.resourceSet.getResource(modelUri, true);
        return (EPackage)resourceModel.getContents().get(0);
    }

    private EObject loadPetriInstanceModel() {
        URI instanceUri = URI.createFileURI((String)new File(MODEL_PETRI_INSTANCE).getAbsolutePath());
        Resource resourceInstance = this.resourceSet.getResource(instanceUri, true);
        if (resourceInstance.isLoaded()) {
            resourceInstance.unload();
            try {
                resourceInstance.load(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (EObject)resourceInstance.getContents().get(0);
    }

    private void initializeResourceFactories() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("henshin", new HenshinResourceFactory());
    }

    public static void main(String[] args) {
        Evolution1 test = new Evolution1();
        test.start();
    }
}

