/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.validation;

public class StateSpaceXYPlot {
    private String xName;
    private String yName;
    private double[][] xValues;
    private double[][] yValues;
    private double xMin = 0.0;
    private double yMin = 0.0;
    private double xMax = 0.0;
    private double yMax = 0.0;
    private int xMaxSegments = 0;
    private int yMaxSegments = 0;
    private String[] legend;

    public StateSpaceXYPlot(String xName, String yName, double[][] xValues, double[][] yValues, String[] legend) {
        this.xName = xName;
        this.yName = yName;
        this.xValues = xValues;
        this.yValues = yValues;
        this.legend = legend;
        int series = 0;
        while (series < this.getSeriesCount()) {
            int point = 0;
            while (point < this.getSeriesLength(series)) {
                double x = xValues[series][point];
                double y = yValues[series][point];
                this.xMin = Math.min(this.xMin, x);
                this.yMin = Math.min(this.yMin, y);
                this.xMax = Math.max(this.xMax, x);
                this.yMax = Math.max(this.yMax, y);
                this.xMaxSegments = Math.max(this.xMaxSegments, xValues[series].length);
                this.yMaxSegments = Math.max(this.yMaxSegments, yValues[series].length);
                ++point;
            }
            ++series;
        }
    }

    public int getSeriesCount() {
        return Math.min(this.xValues.length, this.yValues.length);
    }

    public int getSeriesLength(int series) {
        return Math.min(this.xValues[series].length, this.yValues[series].length);
    }

    public double getX(int series, int point) {
        return this.xValues[series][point];
    }

    public double getY(int series, int point) {
        return this.yValues[series][point];
    }

    public int getXScaled(int series, int point, int span) {
        double value = this.xValues[series][point];
        return (int)((double)span * value / this.xMax);
    }

    public int getYScaled(int series, int point, int span) {
        double value = this.yValues[series][point];
        return (int)((double)span * value / this.yMax);
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMax() {
        return this.yMax;
    }

    public int getXMaxSegments() {
        return this.xMaxSegments;
    }

    public int getYMaxSegments() {
        return this.yMaxSegments;
    }

    public String getXName() {
        return this.xName;
    }

    public String getYName() {
        return this.yName;
    }

    public String getLegend(int series) {
        if (this.legend != null && series < this.legend.length) {
            return this.legend[series];
        }
        return null;
    }
}

