/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.validation;

import java.text.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.Trace;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSearch;
import org.eclipse.emf.henshin.statespace.validation.StateSpaceValidator;
import org.eclipse.emf.henshin.statespace.validation.StateValidator;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class InvariantStateSpaceValidator
extends StateSpaceSearch
implements StateSpaceValidator {
    private StateValidator validator;
    private boolean valid;
    private Exception exception;
    private IProgressMonitor monitor;

    public InvariantStateSpaceValidator(StateValidator validator) {
        if (validator == null) {
            throw new IllegalArgumentException();
        }
        this.validator = validator;
    }

    @Override
    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        this.monitor = monitor;
        monitor.beginTask("Validating invariant...", stateSpace.getStates().size());
        this.reset();
        this.depthFirst(stateSpace, false);
        if (monitor.isCanceled()) {
            return null;
        }
        monitor.done();
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.valid) {
            return new ValidationResult(true, "Invariant satisfied.");
        }
        Trace trace = this.getTrace();
        int error = trace.getTarget().getIndex();
        return new ValidationResult(false, "Invariant not satisfied in state " + error + ".", this.getTrace());
    }

    @Override
    public void reset() {
        super.reset();
        this.valid = true;
        this.exception = null;
    }

    @Override
    protected boolean shouldStop(State current, Trace trace) {
        if (this.monitor.isCanceled()) {
            return true;
        }
        try {
            ValidationResult result = this.validator.validate(current, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!result.isValid()) {
                this.valid = false;
                return true;
            }
        }
        catch (Exception e) {
            this.exception = e;
            return true;
        }
        this.monitor.worked(1);
        return false;
    }

    @Override
    public String getName() {
        return String.valueOf(this.validator.getName()) + " (invariant)";
    }

    @Override
    public void setProperty(String property) throws ParseException {
        this.validator.setProperty(property);
    }

    @Override
    public void setStateSpaceIndex(StateSpaceIndex index) {
        this.validator.setStateSpaceIndex(index);
    }

    @Override
    public boolean usesProperty() {
        return true;
    }
}

