/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.validation;

import java.text.ParseException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.validation.StateValidator;
import org.eclipse.emf.henshin.statespace.validation.ValidationResult;

public class SingleRootStateValidator
implements StateValidator {
    private StateSpaceIndex index;

    @Override
    public ValidationResult validate(State state, IProgressMonitor monitor) throws Exception {
        Resource resource = this.index.getModel(state).getResource();
        monitor.done();
        if (resource.getContents().size() == 1) {
            return ValidationResult.VALID;
        }
        return new ValidationResult(false, "State " + state.getIndex() + " has " + resource.getContents().size() + " root nodes.");
    }

    @Override
    public boolean usesProperty() {
        return false;
    }

    @Override
    public void setProperty(String property) throws ParseException {
    }

    @Override
    public void setStateSpaceIndex(StateSpaceIndex index) {
        this.index = index;
    }

    @Override
    public String getName() {
        return "Single root";
    }
}

