/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMStateSpaceExporter;

public abstract class AbstractPRISMTool
extends AbstractFileBasedValidator {
    public static final String PRISM_PATH_KEY = "prismPath";
    public static final String PRISM_ARGS_KEY = "prismArgs";

    protected Process invokePRISM(StateSpace stateSpace, File formulaFile, String[] args, IProgressMonitor monitor) throws Exception {
        String arg;
        int n;
        int n2;
        String[] stringArray;
        File smFile = this.generatePRISMFile(stateSpace, monitor);
        String prism = this.getPRISMExecutable();
        String baseArgs = (String)stateSpace.getProperties().get((Object)PRISM_ARGS_KEY);
        if (baseArgs == null) {
            baseArgs = "-fixdl -gaussseidel";
        }
        String path = (String)stateSpace.getProperties().get((Object)PRISM_PATH_KEY);
        ArrayList<String> command = new ArrayList<String>();
        command.add(path != null ? new File(String.valueOf(path) + File.separator + prism).getAbsolutePath() : prism);
        command.add(smFile.getAbsolutePath());
        if (formulaFile != null) {
            command.add(formulaFile.getAbsolutePath());
        }
        if (baseArgs != null) {
            stringArray = baseArgs.split(" ");
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                arg = stringArray[n];
                command.add(arg.trim());
                ++n;
            }
        }
        if (args != null) {
            stringArray = args;
            n2 = args.length;
            n = 0;
            while (n < n2) {
                arg = stringArray[n];
                command.add(arg.trim());
                ++n;
            }
        }
        System.out.println(command);
        return Runtime.getRuntime().exec(command.toArray(new String[0]), null, path != null ? new File(path) : null);
    }

    protected File generatePRISMFile(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        String filename = stateSpace.eResource() != null ? stateSpace.eResource().getURI().trimFileExtension().lastSegment() : "statespace";
        File tmp = File.createTempFile(filename, ".sm");
        URI uri = URI.createFileURI((String)tmp.getAbsolutePath());
        PRISMStateSpaceExporter exporter = new PRISMStateSpaceExporter();
        exporter.export(stateSpace, uri, monitor);
        return tmp;
    }

    protected String getPRISMExecutable() {
        return this.isWindows() ? "prism.bat" : "prism";
    }
}

