/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.henshin.internal.constraints.Constraint;
import org.eclipse.emf.henshin.internal.matching.AttributeConstraint;
import org.eclipse.emf.henshin.internal.matching.DanglingConstraint;
import org.eclipse.emf.henshin.internal.matching.ParameterConstraint;
import org.eclipse.emf.henshin.internal.matching.ReferenceConstraint;
import org.eclipse.emf.henshin.internal.matching.TypeConstraint;

public class Variable {
    private TypeConstraint typeConstraint;
    private Collection<AttributeConstraint> attributeConstraints;
    private Collection<DanglingConstraint> danglingConstraints;
    private Collection<ReferenceConstraint> referenceConstraints;
    private Collection<ParameterConstraint> parameterConstraints;

    public Variable(EClass type) {
        this.typeConstraint = new TypeConstraint(type);
        this.attributeConstraints = new HashSet<AttributeConstraint>();
        this.danglingConstraints = new HashSet<DanglingConstraint>();
        this.referenceConstraints = new HashSet<ReferenceConstraint>();
        this.parameterConstraints = new HashSet<ParameterConstraint>();
    }

    public void addConstraint(Constraint constraint) {
        if (constraint instanceof AttributeConstraint) {
            this.attributeConstraints.add((AttributeConstraint)constraint);
        } else if (constraint instanceof DanglingConstraint) {
            this.danglingConstraints.add((DanglingConstraint)constraint);
        } else if (constraint instanceof ReferenceConstraint) {
            this.referenceConstraints.add((ReferenceConstraint)constraint);
        } else if (constraint instanceof ParameterConstraint) {
            this.parameterConstraints.add((ParameterConstraint)constraint);
        } else {
            throw new IllegalArgumentException("Unknown constraint");
        }
    }

    public TypeConstraint getTypeConstraint() {
        return this.typeConstraint;
    }

    public Collection<AttributeConstraint> getAttributeConstraints() {
        return this.attributeConstraints;
    }

    public Collection<DanglingConstraint> getDanglingConstraints() {
        return this.danglingConstraints;
    }

    public Collection<ReferenceConstraint> getReferenceConstraints() {
        return this.referenceConstraints;
    }

    public Collection<ParameterConstraint> getParameterConstraints() {
        return this.parameterConstraints;
    }
}

