/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.internal.constraints.UnaryConstraint;
import org.eclipse.emf.henshin.internal.matching.DomainSlot;

public class TypeConstraint
implements UnaryConstraint {
    EClass type;

    public TypeConstraint(EClass type) {
        this.type = type;
    }

    @Override
    public boolean check(DomainSlot slot) {
        if (slot.locked) {
            return this.type.isSuperTypeOf(slot.value.eClass());
        }
        return true;
    }

    public boolean initDomain(DomainSlot slot, EmfGraph graph) {
        if (slot.domain == null) {
            slot.domain = new ArrayList<EObject>(graph.getDomainForType(this.type));
        } else if (slot.domain != null && !slot.domain.isEmpty()) {
            int i = slot.domain.size() - 1;
            while (i >= 0) {
                EObject eObject = slot.domain.get(i);
                if (eObject != null && !this.type.isSuperTypeOf(eObject.eClass())) {
                    slot.domain.remove(i);
                }
                --i;
            }
        }
        return !slot.domain.isEmpty();
    }
}

