/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.internal.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.henshin.common.util.EmfGraph;
import org.eclipse.emf.henshin.internal.conditions.attribute.AttributeConditionHandler;
import org.eclipse.emf.henshin.internal.conditions.nested.ApplicationCondition;
import org.eclipse.emf.henshin.internal.matching.DomainSlot;
import org.eclipse.emf.henshin.internal.matching.Solution;
import org.eclipse.emf.henshin.internal.matching.Variable;

public class Matchfinder
extends ApplicationCondition {
    private List<Solution> solutions;
    private AttributeConditionHandler conditionHandler;

    public Matchfinder(EmfGraph emfGraph, Map<Variable, DomainSlot> variableDomainMap, AttributeConditionHandler conditionHandler) {
        super(emfGraph, variableDomainMap, false);
        this.conditionHandler = conditionHandler;
    }

    public boolean findSolution() {
        boolean matchIsPossible = false;
        if (this.solutions == null) {
            this.solutions = new ArrayList<Solution>();
            matchIsPossible = true;
        } else {
            int i = this.variables.size() - 1;
            while (i >= 0) {
                Variable var = (Variable)this.variables.get(i);
                if (((DomainSlot)this.domainMap.get(var)).unlock(var)) {
                    matchIsPossible = true;
                    break;
                }
                ((DomainSlot)this.domainMap.get(var)).clear(var);
                --i;
            }
        }
        if (matchIsPossible) {
            boolean success = this.findGraph();
            if (success) {
                this.solutions.add(new Solution(this.variables, this.domainMap, this.conditionHandler));
            }
            return success;
        }
        return false;
    }

    public Solution getRandomMatch() {
        while (this.getNextMatch() != null) {
        }
        if (this.solutions.size() > 0) {
            int x = new Random().nextInt(this.solutions.size());
            return this.solutions.get(x);
        }
        return null;
    }

    public Solution getNextMatch() {
        boolean success = this.findSolution();
        if (success) {
            return this.solutions.get(this.solutions.size() - 1);
        }
        return null;
    }

    public List<Solution> getAllMatches() {
        while (this.getNextMatch() != null) {
        }
        return this.solutions;
    }
}

