/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.util.HenshinMappingUtil;
import org.eclipse.emf.henshin.model.util.HenshinRuleAnalysisUtil;

public class HenshinNACUtil {
    public static List<NestedCondition> getAllNACs(Rule rule) {
        ArrayList<NestedCondition> nacs = new ArrayList<NestedCondition>();
        HenshinNACUtil.addNACs(rule.getLhs().getFormula(), nacs);
        return nacs;
    }

    public static NestedCondition getNAC(Rule rule, String name) {
        for (NestedCondition nac : HenshinNACUtil.getAllNACs(rule)) {
            if (!name.equals(nac.getConclusion().getName())) continue;
            return nac;
        }
        return null;
    }

    private static void addNACs(Formula formula, List<NestedCondition> nacs) {
        NestedCondition nested;
        if (formula instanceof And) {
            HenshinNACUtil.addNACs(((And)formula).getLeft(), nacs);
            HenshinNACUtil.addNACs(((And)formula).getRight(), nacs);
        } else if (formula instanceof NestedCondition && (nested = (NestedCondition)formula).isNegated()) {
            nacs.add(nested);
        }
    }

    public static NestedCondition createNAC(Rule rule, String name) {
        NestedCondition nac = HenshinFactory.eINSTANCE.createNestedCondition();
        nac.setNegated(true);
        Graph graph = HenshinFactory.eINSTANCE.createGraph();
        graph.setName(name);
        nac.setConclusion(graph);
        if (rule.getLhs().getFormula() == null) {
            rule.getLhs().setFormula(nac);
        } else {
            And and = HenshinFactory.eINSTANCE.createAnd();
            and.setLeft(rule.getLhs().getFormula());
            and.setRight(nac);
            rule.getLhs().setFormula(and);
        }
        return nac;
    }

    public static void removeNAC(Rule rule, NestedCondition nac) {
        EObject container = nac.eContainer();
        EcoreUtil.remove((EObject)nac);
        if (container instanceof BinaryFormula) {
            BinaryFormula binary = (BinaryFormula)container;
            Formula remainder = binary.getLeft() != null ? binary.getLeft() : binary.getRight();
            EcoreUtil.replace((EObject)binary, (EObject)remainder);
        }
    }

    public static boolean isTrivialNAC(NestedCondition nac) {
        Graph graph = nac.getConclusion();
        EList<Mapping> mappings = nac.getMappings();
        for (Node node : graph.getNodes()) {
            if (HenshinMappingUtil.getNodeOrigin(node, mappings) == null) {
                return false;
            }
            for (Attribute attribute : node.getAttributes()) {
                Attribute origin = HenshinMappingUtil.getAttributeOrigin(attribute, mappings);
                if (origin != null && HenshinRuleAnalysisUtil.valueEquals(attribute.getValue(), origin.getValue())) continue;
                return false;
            }
        }
        for (Edge edge : graph.getEdges()) {
            if (HenshinMappingUtil.getEdgeOrigin(edge, mappings) != null) continue;
            return false;
        }
        return true;
    }

    public static void removeTrivialNACs(Rule rule) {
        for (NestedCondition nac : HenshinNACUtil.getAllNACs(rule)) {
            if (!HenshinNACUtil.isTrivialNAC(nac)) continue;
            HenshinNACUtil.removeNAC(rule, nac);
        }
    }
}

