/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.edit;

import java.util.ArrayList;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.henshin.statespace.Transition;
import org.eclipse.emf.henshin.statespace.explorer.edit.TransitionLabelLocator;
import org.eclipse.emf.henshin.statespace.util.TransitionBendpointHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;

public class TransitionEditPart
extends AbstractConnectionEditPart {
    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connection = new PolylineConnection();
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        connection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        Label label = new Label(this.getTransition().getLabel());
        connection.add((IFigure)label);
        connection.getLayoutManager().setConstraint((IFigure)label, (Object)new TransitionLabelLocator(this.getTransition(), (Connection)connection));
        return connection;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int[][] bendpoints = TransitionBendpointHelper.getBendPoints((Transition)this.getTransition());
        ArrayList<RelativeBendpoint> relative = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < bendpoints.length) {
            RelativeBendpoint bendpoint = new RelativeBendpoint(this.getConnectionFigure());
            Dimension d1 = new Dimension(bendpoints[i][0], bendpoints[i][1]);
            Dimension d2 = new Dimension(bendpoints[i][2], bendpoints[i][3]);
            bendpoint.setRelativeDimensions(d1, d2);
            relative.add(bendpoint);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(relative);
    }

    public Transition getTransition() {
        return (Transition)this.getModel();
    }
}

