/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.util.StateSpaceSpringLayouter;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class MoveStateCommand
extends Command {
    private Point oldLocation;
    private Point newLocation;
    private final ChangeBoundsRequest request;
    private final State state;
    private StateSpaceSpringLayouter layouter;

    public MoveStateCommand(State state, ChangeBoundsRequest req, Rectangle newBounds) {
        if (state == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.state = state;
        this.request = req;
        this.newLocation = newBounds.getLocation();
        this.setLabel("move");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type);
    }

    public void execute() {
        int[] loc = this.state.getLocation();
        this.oldLocation = new Point(loc[0], loc[1]);
        this.redo();
    }

    public void redo() {
        if (this.layouter != null) {
            this.layouter.setPosition(this.state, new int[]{this.newLocation.x, this.newLocation.y});
        }
        this.state.setLocation(new int[]{this.newLocation.x, this.newLocation.y});
    }

    public void undo() {
        if (this.layouter != null) {
            this.layouter.setPosition(this.state, new int[]{this.oldLocation.x, this.oldLocation.y});
        }
        this.state.setLocation(new int[]{this.oldLocation.x, this.oldLocation.y});
    }

    public void setLayouter(StateSpaceSpringLayouter layouter) {
        this.layouter = layouter;
    }
}

