/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.TransformationSystem;
import org.eclipse.emf.henshin.presentation.HenshinIcons;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ImportRulesPage
extends WizardPage {
    private List<Rule> rules = new ArrayList<Rule>();
    private Tree tree;
    private Resource stateSpaceResource;

    protected ImportRulesPage() {
        super("Import Rules");
        this.setDescription("Add or remove transformation rules to be used for this state space.");
    }

    public void setStateSpaceResource(Resource resource) {
        this.stateSpaceResource = resource;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.tree = new Tree(container, 2052);
        this.tree.setLayoutData((Object)new GridData(1808));
        for (Rule rule : this.rules) {
            this.addRuleTreeItem(rule);
        }
        this.tree.deselectAll();
        Composite buttons = new Composite(container, 0);
        buttons.setLayoutData((Object)new GridData(1));
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.createButton(buttons, "Add");
        this.createButton(buttons, "Remove");
        this.setControl((Control)container);
    }

    public void add() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new RuleLabelProvider(), (ITreeContentProvider)new RuleContentProvider());
        dialog.setTitle("Select Rule");
        dialog.setMessage("Please select the transformation rule to be imported:");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        dialog.setInput((Object)root);
        URI uri = this.stateSpaceResource.getURI().trimSegments(1);
        IResource container = root.findMember(uri.toPlatformString(true));
        if (container != null) {
            dialog.setInitialSelection((Object)container);
        }
        dialog.addFilter((ViewerFilter)new RuleViewFilter());
        dialog.setValidator((ISelectionStatusValidator)new RuleSelectionValidator());
        dialog.setAllowMultiple(true);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null) {
            return;
        }
        int i = 0;
        while (i < result.length) {
            Rule rule;
            if (result[i] instanceof Rule && !this.rules.contains(rule = (Rule)result[i])) {
                this.rules.add(rule);
                this.addRuleTreeItem(rule);
            }
            ++i;
        }
    }

    private void addRuleTreeItem(Rule rule) {
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText(String.valueOf(rule.getName()) + " (" + rule.eResource().getURI().path() + ")");
        item.setImage(HenshinIcons.RULE);
    }

    public void remove() {
        TreeItem[] items = this.tree.getSelection();
        if (items != null && items.length > 0) {
            int index = this.tree.indexOf(items[0]);
            items[0].dispose();
            this.rules.remove(index);
        }
    }

    private Button createButton(Composite parent, final String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.setLayoutData((Object)new GridData(768));
        final ImportRulesPage thisPage = this;
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    Method method = ImportRulesPage.class.getMethod(name.toLowerCase(), new Class[0]);
                    if (method != null) {
                        method.invoke((Object)thisPage, new Object[0]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        return button;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    class RuleContentProvider
    extends BaseWorkbenchContentProvider {
        RuleContentProvider() {
        }

        public Object[] getChildren(Object element) {
            IResource res;
            IAdaptable adapter;
            Object adaptedResource;
            if (element instanceof IAdaptable && (adaptedResource = (adapter = (IAdaptable)element).getAdapter(IResource.class)) != null && "henshin".equals((res = (IResource)adaptedResource).getFileExtension())) {
                String filePath = res.getFullPath().toString();
                URI baseURI = ImportRulesPage.this.stateSpaceResource.getURI();
                URI absolute = URI.createPlatformResourceURI((String)filePath, (boolean)true);
                URI relative = absolute.deresolve(baseURI);
                ResourceSet resourceSet = ImportRulesPage.this.stateSpaceResource.getResourceSet();
                Resource resource = resourceSet.getResource(absolute, true);
                resource.setURI(relative);
                ArrayList rules = new ArrayList();
                for (EObject item : resource.getContents()) {
                    if (!(item instanceof TransformationSystem)) continue;
                    rules.addAll(((TransformationSystem)item).getRules());
                }
                return rules.toArray();
            }
            return super.getChildren(element);
        }
    }

    static class RuleLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        RuleLabelProvider() {
        }

        public Image getImage(Object element) {
            IAdaptable adaptable;
            Object adapter;
            if (element instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                IWorkbenchAdapter res = (IWorkbenchAdapter)adapter;
                return res.getImageDescriptor(element).createImage();
            }
            if (element instanceof Rule) {
                return HenshinIcons.RULE;
            }
            return null;
        }

        public String getText(Object element) {
            IAdaptable adaptable;
            Object adapter;
            if (element instanceof IAdaptable && (adapter = (adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) != null) {
                IWorkbenchAdapter res = (IWorkbenchAdapter)adapter;
                return res.getLabel(element);
            }
            if (element instanceof Rule) {
                return ((Rule)element).getName();
            }
            return element.toString();
        }
    }

    static class RuleSelectionValidator
    implements ISelectionStatusValidator {
        RuleSelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            Object obj;
            if (selection.length > 0 && (obj = selection[0]) instanceof Rule) {
                return new Status(0, "org.eclipse.emf.henshin.statespace.explorer", "Rule selected");
            }
            return new Status(4, "org.eclipse.emf.henshin.statespace.explorer", "No rule selected");
        }
    }

    static class RuleViewFilter
    extends ViewerFilter {
        RuleViewFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IResource res;
            IAdaptable adapter;
            Object adaptedResource;
            if (element instanceof IAdaptable && (adaptedResource = (adapter = (IAdaptable)element).getAdapter(IResource.class)) != null && ("henshin".equals((res = (IResource)adaptedResource).getFileExtension()) || 1 != res.getType())) {
                return true;
            }
            return element instanceof Rule;
        }
    }
}

